package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DelegatedAdminCustomer;
import odata.msgraph.client.beta.entity.request.DelegatedAdminCustomerRequest;
import odata.msgraph.client.beta.entity.request.DelegatedAdminServiceManagementDetailRequest;

public class DelegatedAdminCustomerCollectionRequest extends CollectionPageEntityRequest<DelegatedAdminCustomer, DelegatedAdminCustomerRequest>{

    protected ContextPath contextPath;

    public DelegatedAdminCustomerCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DelegatedAdminCustomer.class, cp -> new DelegatedAdminCustomerRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DelegatedAdminServiceManagementDetailRequest serviceManagementDetails(String id) {
        return new DelegatedAdminServiceManagementDetailRequest(contextPath.addSegment("serviceManagementDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminServiceManagementDetailCollectionRequest serviceManagementDetails() {
        return new DelegatedAdminServiceManagementDetailCollectionRequest(contextPath.addSegment("serviceManagementDetails"), Optional.empty());
    }

}
