package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ConversationThread;
import odata.msgraph.client.beta.entity.request.ConversationThreadRequest;
import odata.msgraph.client.beta.entity.request.PostRequest;

public class ConversationThreadCollectionRequest extends CollectionPageEntityRequest<ConversationThread, ConversationThreadRequest>{

    protected ContextPath contextPath;

    public ConversationThreadCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ConversationThread.class, cp -> new ConversationThreadRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PostRequest posts(String id) {
        return new PostRequest(contextPath.addSegment("posts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PostCollectionRequest posts() {
        return new PostCollectionRequest(contextPath.addSegment("posts"), Optional.empty());
    }

}
