package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Conversation;
import odata.msgraph.client.beta.entity.request.ConversationRequest;
import odata.msgraph.client.beta.entity.request.ConversationThreadRequest;

public class ConversationCollectionRequest extends CollectionPageEntityRequest<Conversation, ConversationRequest>{

    protected ContextPath contextPath;

    public ConversationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Conversation.class, cp -> new ConversationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ConversationThreadRequest threads(String id) {
        return new ConversationThreadRequest(contextPath.addSegment("threads").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationThreadCollectionRequest threads() {
        return new ConversationThreadCollectionRequest(contextPath.addSegment("threads"), Optional.empty());
    }

}
