package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ContentType;
import odata.msgraph.client.beta.entity.request.ColumnDefinitionRequest;
import odata.msgraph.client.beta.entity.request.ColumnLinkRequest;
import odata.msgraph.client.beta.entity.request.ContentTypeRequest;

public class ContentTypeCollectionRequest extends CollectionPageEntityRequest<ContentType, ContentTypeRequest>{

    protected ContextPath contextPath;

    public ContentTypeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ContentType.class, cp -> new ContentTypeRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ContentTypeRequest baseTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("baseTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContentTypeCollectionRequest baseTypes() {
        return new ContentTypeCollectionRequest(contextPath.addSegment("baseTypes"), Optional.empty());
    }

    public ColumnLinkRequest columnLinks(String id) {
        return new ColumnLinkRequest(contextPath.addSegment("columnLinks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnLinkCollectionRequest columnLinks() {
        return new ColumnLinkCollectionRequest(contextPath.addSegment("columnLinks"), Optional.empty());
    }

    public ColumnDefinitionRequest columnPositions(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columnPositions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columnPositions() {
        return new ColumnDefinitionCollectionRequest(contextPath.addSegment("columnPositions"), Optional.empty());
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(contextPath.addSegment("columns"), Optional.empty());
    }

    @Action(name = "addCopy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ContentType> addCopy(String contentType) {
        Preconditions.checkNotNull(contentType, "contentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentType", "Edm.String", Checks.checkIsAscii(contentType))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ContentType>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addCopy"), ContentType.class, _parameters);
    }

    @Action(name = "addCopyFromContentTypeHub")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ContentType> addCopyFromContentTypeHub(String contentTypeId) {
        Preconditions.checkNotNull(contentTypeId, "contentTypeId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentTypeId", "Edm.String", Checks.checkIsAscii(contentTypeId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ContentType>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addCopyFromContentTypeHub"), ContentType.class, _parameters);
    }

    @Function(name = "getCompatibleHubContentTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ContentType> getCompatibleHubContentTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCompatibleHubContentTypes"), ContentType.class, _parameters);
    }

}
