package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ConnectorGroup;
import odata.msgraph.client.beta.entity.request.ApplicationRequest;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.ConnectorRequest;

public class ConnectorGroupCollectionRequest extends CollectionPageEntityRequest<ConnectorGroup, ConnectorGroupRequest>{

    protected ContextPath contextPath;

    public ConnectorGroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ConnectorGroup.class, cp -> new ConnectorGroupRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ApplicationRequest applications(String id) {
        return new ApplicationRequest(contextPath.addSegment("applications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApplicationCollectionRequest applications() {
        return new ApplicationCollectionRequest(contextPath.addSegment("applications"), Optional.empty());
    }

    public ConnectorRequest members(String id) {
        return new ConnectorRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorCollectionRequest members() {
        return new ConnectorCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

}
