package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Connector;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.ConnectorRequest;

public class ConnectorCollectionRequest extends CollectionPageEntityRequest<Connector, ConnectorRequest>{

    protected ContextPath contextPath;

    public ConnectorCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Connector.class, cp -> new ConnectorRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ConnectorGroupRequest memberOf(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorGroupCollectionRequest memberOf() {
        return new ConnectorGroupCollectionRequest(contextPath.addSegment("memberOf"), Optional.empty());
    }

}
