package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ConnectedOrganization;
import odata.msgraph.client.beta.entity.request.ConnectedOrganizationRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;

public class ConnectedOrganizationCollectionRequest extends CollectionPageEntityRequest<ConnectedOrganization, ConnectedOrganizationRequest>{

    protected ContextPath contextPath;

    public ConnectedOrganizationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ConnectedOrganization.class, cp -> new ConnectedOrganizationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DirectoryObjectRequest externalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("externalSponsors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest externalSponsors() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("externalSponsors"), Optional.empty());
    }

    public DirectoryObjectRequest internalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("internalSponsors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest internalSponsors() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("internalSponsors"), Optional.empty());
    }

}
