package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ConfigManagerPolicySummary;
import odata.msgraph.client.beta.entity.ConfigManagerCollection;
import odata.msgraph.client.beta.entity.request.ConfigManagerCollectionRequest;

public class ConfigManagerCollectionCollectionRequest extends CollectionPageEntityRequest<ConfigManagerCollection, ConfigManagerCollectionRequest>{

    protected ContextPath contextPath;

    public ConfigManagerCollectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ConfigManagerCollection.class, cp -> new ConfigManagerCollectionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "getPolicySummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ConfigManagerPolicySummary> getPolicySummary(String policyId) {
        Preconditions.checkNotNull(policyId, "policyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("policyId", "Edm.String", Checks.checkIsAscii(policyId))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ConfigManagerPolicySummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicySummary"), ConfigManagerPolicySummary.class, _parameters);
    }

}
