package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CloudPcUserSetting;
import odata.msgraph.client.beta.entity.request.CloudPcUserSettingAssignmentRequest;
import odata.msgraph.client.beta.entity.request.CloudPcUserSettingRequest;

public class CloudPcUserSettingCollectionRequest extends CollectionPageEntityRequest<CloudPcUserSetting, CloudPcUserSettingRequest>{

    protected ContextPath contextPath;

    public CloudPcUserSettingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CloudPcUserSetting.class, cp -> new CloudPcUserSettingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CloudPcUserSettingAssignmentRequest assignments(String id) {
        return new CloudPcUserSettingAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcUserSettingAssignmentCollectionRequest assignments() {
        return new CloudPcUserSettingAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

}
