package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ChromeOSOnboardingSettings;
import odata.msgraph.client.beta.entity.request.ChromeOSOnboardingSettingsRequest;
import odata.msgraph.client.beta.enums.ChromeOSOnboardingStatus;

public class ChromeOSOnboardingSettingsCollectionRequest extends CollectionPageEntityRequest<ChromeOSOnboardingSettings, ChromeOSOnboardingSettingsRequest>{

    protected ContextPath contextPath;

    public ChromeOSOnboardingSettingsCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ChromeOSOnboardingSettings.class, cp -> new ChromeOSOnboardingSettingsRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "connect")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ChromeOSOnboardingStatus> connect(String ownerUserPrincipalName, String ownerAccessToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ownerUserPrincipalName", "Edm.String", Checks.checkIsAscii(ownerUserPrincipalName))
            .put("ownerAccessToken", "Edm.String", Checks.checkIsAscii(ownerAccessToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ChromeOSOnboardingStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.connect"), ChromeOSOnboardingStatus.class, _parameters);
    }

    @Action(name = "disconnect")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ChromeOSOnboardingStatus> disconnect() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<ChromeOSOnboardingStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disconnect"), ChromeOSOnboardingStatus.class, _parameters);
    }

}
