package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Chat;
import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.request.ChatMessageRequest;
import odata.msgraph.client.beta.entity.request.ChatRequest;
import odata.msgraph.client.beta.entity.request.ConversationMemberRequest;
import odata.msgraph.client.beta.entity.request.ResourceSpecificPermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.TeamsAppInstallationRequest;
import odata.msgraph.client.beta.entity.request.TeamsAsyncOperationRequest;
import odata.msgraph.client.beta.entity.request.TeamsTabRequest;

public class ChatCollectionRequest extends CollectionPageEntityRequest<Chat, ChatRequest>{

    protected ContextPath contextPath;

    public ChatCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Chat.class, cp -> new ChatRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamsAppInstallationRequest installedApps(String id) {
        return new TeamsAppInstallationRequest(contextPath.addSegment("installedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAppInstallationCollectionRequest installedApps() {
        return new TeamsAppInstallationCollectionRequest(contextPath.addSegment("installedApps"), Optional.empty());
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

    public ChatMessageRequest messages(String id) {
        return new ChatMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatMessageCollectionRequest messages() {
        return new ChatMessageCollectionRequest(contextPath.addSegment("messages"), Optional.empty());
    }

    public TeamsAsyncOperationRequest operations(String id) {
        return new TeamsAsyncOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAsyncOperationCollectionRequest operations() {
        return new TeamsAsyncOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ResourceSpecificPermissionGrantCollectionRequest permissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(contextPath.addSegment("permissionGrants"), Optional.empty());
    }

    public TeamsTabRequest tabs(String id) {
        return new TeamsTabRequest(contextPath.addSegment("tabs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsTabCollectionRequest tabs() {
        return new TeamsTabCollectionRequest(contextPath.addSegment("tabs"), Optional.empty());
    }

    @Function(name = "allMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> allMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.allMessages"), ChatMessage.class, _parameters);
    }

    @Function(name = "getAllMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> getAllMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAllMessages"), ChatMessage.class, _parameters);
    }

}
