package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.TeleconferenceDeviceQuality;
import odata.msgraph.client.beta.entity.Call;
import odata.msgraph.client.beta.entity.request.AudioRoutingGroupRequest;
import odata.msgraph.client.beta.entity.request.CallRequest;
import odata.msgraph.client.beta.entity.request.CommsOperationRequest;
import odata.msgraph.client.beta.entity.request.ParticipantRequest;

public class CallCollectionRequest extends CollectionPageEntityRequest<Call, CallRequest>{

    protected ContextPath contextPath;

    public CallCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Call.class, cp -> new CallRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AudioRoutingGroupRequest audioRoutingGroups(String id) {
        return new AudioRoutingGroupRequest(contextPath.addSegment("audioRoutingGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AudioRoutingGroupCollectionRequest audioRoutingGroups() {
        return new AudioRoutingGroupCollectionRequest(contextPath.addSegment("audioRoutingGroups"), Optional.empty());
    }

    public CommsOperationRequest operations(String id) {
        return new CommsOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CommsOperationCollectionRequest operations() {
        return new CommsOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    public ParticipantRequest participants(String id) {
        return new ParticipantRequest(contextPath.addSegment("participants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ParticipantCollectionRequest participants() {
        return new ParticipantCollectionRequest(contextPath.addSegment("participants"), Optional.empty());
    }

    @Action(name = "logTeleconferenceDeviceQuality")
    @JsonIgnore
    public ActionRequestNoReturn logTeleconferenceDeviceQuality(TeleconferenceDeviceQuality quality) {
        Preconditions.checkNotNull(quality, "quality cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("quality", "microsoft.graph.teleconferenceDeviceQuality", quality)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.logTeleconferenceDeviceQuality"), _parameters);
    }

}
