package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CalendarGroup;
import odata.msgraph.client.beta.entity.request.CalendarGroupRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;

public class CalendarGroupCollectionRequest extends CollectionPageEntityRequest<CalendarGroup, CalendarGroupRequest>{

    protected ContextPath contextPath;

    public CalendarGroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CalendarGroup.class, cp -> new CalendarGroupRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(contextPath.addSegment("calendars"), Optional.empty());
    }

}
