package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Calendar;
import odata.msgraph.client.beta.entity.request.CalendarPermissionRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.entity.request.EventRequest;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;

public class CalendarCollectionRequest extends CollectionPageEntityRequest<Calendar, CalendarRequest>{

    protected ContextPath contextPath;

    public CalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Calendar.class, cp -> new CalendarRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CalendarPermissionRequest calendarPermissions(String id) {
        return new CalendarPermissionRequest(contextPath.addSegment("calendarPermissions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarPermissionCollectionRequest calendarPermissions() {
        return new CalendarPermissionCollectionRequest(contextPath.addSegment("calendarPermissions"), Optional.empty());
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(contextPath.addSegment("calendarView"), Optional.empty());
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(contextPath.addSegment("events"), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

}
