package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.BookingBusiness;
import odata.msgraph.client.beta.entity.request.BookingAppointmentRequest;
import odata.msgraph.client.beta.entity.request.BookingBusinessRequest;
import odata.msgraph.client.beta.entity.request.BookingCustomQuestionRequest;
import odata.msgraph.client.beta.entity.request.BookingCustomerRequest;
import odata.msgraph.client.beta.entity.request.BookingServiceRequest;
import odata.msgraph.client.beta.entity.request.BookingStaffMemberRequest;

public class BookingBusinessCollectionRequest extends CollectionPageEntityRequest<BookingBusiness, BookingBusinessRequest>{

    protected ContextPath contextPath;

    public BookingBusinessCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, BookingBusiness.class, cp -> new BookingBusinessRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BookingAppointmentRequest appointments(String id) {
        return new BookingAppointmentRequest(contextPath.addSegment("appointments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingAppointmentCollectionRequest appointments() {
        return new BookingAppointmentCollectionRequest(contextPath.addSegment("appointments"), Optional.empty());
    }

    public BookingAppointmentRequest calendarView(String id) {
        return new BookingAppointmentRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingAppointmentCollectionRequest calendarView() {
        return new BookingAppointmentCollectionRequest(contextPath.addSegment("calendarView"), Optional.empty());
    }

    public BookingCustomerRequest customers(String id) {
        return new BookingCustomerRequest(contextPath.addSegment("customers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingCustomerCollectionRequest customers() {
        return new BookingCustomerCollectionRequest(contextPath.addSegment("customers"), Optional.empty());
    }

    public BookingCustomQuestionRequest customQuestions(String id) {
        return new BookingCustomQuestionRequest(contextPath.addSegment("customQuestions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingCustomQuestionCollectionRequest customQuestions() {
        return new BookingCustomQuestionCollectionRequest(contextPath.addSegment("customQuestions"), Optional.empty());
    }

    public BookingServiceRequest services(String id) {
        return new BookingServiceRequest(contextPath.addSegment("services").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingServiceCollectionRequest services() {
        return new BookingServiceCollectionRequest(contextPath.addSegment("services"), Optional.empty());
    }

    public BookingStaffMemberRequest staffMembers(String id) {
        return new BookingStaffMemberRequest(contextPath.addSegment("staffMembers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookingStaffMemberCollectionRequest staffMembers() {
        return new BookingStaffMemberCollectionRequest(contextPath.addSegment("staffMembers"), Optional.empty());
    }

}
