package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AuthorizationPolicy;
import odata.msgraph.client.beta.entity.request.AuthorizationPolicyRequest;
import odata.msgraph.client.beta.entity.request.DefaultUserRoleOverrideRequest;

public class AuthorizationPolicyCollectionRequest extends CollectionPageEntityRequest<AuthorizationPolicy, AuthorizationPolicyRequest>{

    protected ContextPath contextPath;

    public AuthorizationPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AuthorizationPolicy.class, cp -> new AuthorizationPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DefaultUserRoleOverrideRequest defaultUserRoleOverrides(String id) {
        return new DefaultUserRoleOverrideRequest(contextPath.addSegment("defaultUserRoleOverrides").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DefaultUserRoleOverrideCollectionRequest defaultUserRoleOverrides() {
        return new DefaultUserRoleOverrideCollectionRequest(contextPath.addSegment("defaultUserRoleOverrides"), Optional.empty());
    }

}
