package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Approval;
import odata.msgraph.client.beta.entity.request.ApprovalRequest;
import odata.msgraph.client.beta.entity.request.ApprovalStepRequest;
import odata.msgraph.client.beta.enums.ApprovalFilterByCurrentUserOptions;

public class ApprovalCollectionRequest extends CollectionPageEntityRequest<Approval, ApprovalRequest>{

    protected ContextPath contextPath;

    public ApprovalCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Approval.class, cp -> new ApprovalRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ApprovalStepRequest steps(String id) {
        return new ApprovalStepRequest(contextPath.addSegment("steps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApprovalStepCollectionRequest steps() {
        return new ApprovalStepCollectionRequest(contextPath.addSegment("steps"), Optional.empty());
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Approval> filterByCurrentUser(ApprovalFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.approvalFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), Approval.class, _parameters);
    }

}
