package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AppleUserInitiatedEnrollmentProfile;
import odata.msgraph.client.beta.entity.request.AppleEnrollmentProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.AppleUserInitiatedEnrollmentProfileRequest;

public class AppleUserInitiatedEnrollmentProfileCollectionRequest extends CollectionPageEntityRequest<AppleUserInitiatedEnrollmentProfile, AppleUserInitiatedEnrollmentProfileRequest>{

    protected ContextPath contextPath;

    public AppleUserInitiatedEnrollmentProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AppleUserInitiatedEnrollmentProfile.class, cp -> new AppleUserInitiatedEnrollmentProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AppleEnrollmentProfileAssignmentRequest assignments(String id) {
        return new AppleEnrollmentProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppleEnrollmentProfileAssignmentCollectionRequest assignments() {
        return new AppleEnrollmentProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

}
