package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AppConsentRequest;
import odata.msgraph.client.beta.entity.request.AppConsentRequestRequest;
import odata.msgraph.client.beta.entity.request.UserConsentRequestRequest;
import odata.msgraph.client.beta.enums.ConsentRequestFilterByCurrentUserOptions;

public class AppConsentRequestCollectionRequest extends CollectionPageEntityRequest<AppConsentRequest, AppConsentRequestRequest>{

    protected ContextPath contextPath;

    public AppConsentRequestCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AppConsentRequest.class, cp -> new AppConsentRequestRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UserConsentRequestRequest userConsentRequests(String id) {
        return new UserConsentRequestRequest(contextPath.addSegment("userConsentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserConsentRequestCollectionRequest userConsentRequests() {
        return new UserConsentRequestCollectionRequest(contextPath.addSegment("userConsentRequests"), Optional.empty());
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AppConsentRequest> filterByCurrentUser(ConsentRequestFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.consentRequestFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AppConsentRequest.class, _parameters);
    }

}
