package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Alert;
import odata.msgraph.client.beta.entity.request.AlertRequest;

public class AlertCollectionRequest extends CollectionPageEntityRequest<Alert, AlertRequest>{

    protected ContextPath contextPath;

    public AlertCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Alert.class, cp -> new AlertRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "updateAlerts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Alert> updateAlerts(List<Alert> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(microsoft.graph.alert)", value)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateAlerts"), Alert.class, _parameters);
    }

}
