package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewStage;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceDecisionItemRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewStageRequest;
import odata.msgraph.client.beta.enums.AccessReviewStageFilterByCurrentUserOptions;

public class AccessReviewStageCollectionRequest extends CollectionPageEntityRequest<AccessReviewStage, AccessReviewStageRequest>{

    protected ContextPath contextPath;

    public AccessReviewStageCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessReviewStage.class, cp -> new AccessReviewStageRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessReviewInstanceDecisionItemRequest decisions(String id) {
        return new AccessReviewInstanceDecisionItemRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceDecisionItemCollectionRequest decisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(contextPath.addSegment("decisions"), Optional.empty());
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessReviewStage> filterByCurrentUser(AccessReviewStageFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.accessReviewStageFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AccessReviewStage.class, _parameters);
    }

}
