package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewScheduleDefinition;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewScheduleDefinitionRequest;
import odata.msgraph.client.beta.enums.AccessReviewScheduleDefinitionFilterByCurrentUserOptions;

public class AccessReviewScheduleDefinitionCollectionRequest extends CollectionPageEntityRequest<AccessReviewScheduleDefinition, AccessReviewScheduleDefinitionRequest>{

    protected ContextPath contextPath;

    public AccessReviewScheduleDefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessReviewScheduleDefinition.class, cp -> new AccessReviewScheduleDefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessReviewInstanceRequest instances(String id) {
        return new AccessReviewInstanceRequest(contextPath.addSegment("instances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceCollectionRequest instances() {
        return new AccessReviewInstanceCollectionRequest(contextPath.addSegment("instances"), Optional.empty());
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessReviewScheduleDefinition> filterByCurrentUser(AccessReviewScheduleDefinitionFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.accessReviewScheduleDefinitionFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AccessReviewScheduleDefinition.class, _parameters);
    }

}
