package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewInstanceDecisionItem;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceDecisionItemRequest;
import odata.msgraph.client.beta.entity.request.GovernanceInsightRequest;
import odata.msgraph.client.beta.enums.AccessReviewInstanceDecisionItemFilterByCurrentUserOptions;

public class AccessReviewInstanceDecisionItemCollectionRequest extends CollectionPageEntityRequest<AccessReviewInstanceDecisionItem, AccessReviewInstanceDecisionItemRequest>{

    protected ContextPath contextPath;

    public AccessReviewInstanceDecisionItemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessReviewInstanceDecisionItem.class, cp -> new AccessReviewInstanceDecisionItemRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GovernanceInsightRequest insights(String id) {
        return new GovernanceInsightRequest(contextPath.addSegment("insights").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceInsightCollectionRequest insights() {
        return new GovernanceInsightCollectionRequest(contextPath.addSegment("insights"), Optional.empty());
    }

    @Action(name = "recordAllDecisions")
    @JsonIgnore
    public ActionRequestNoReturn recordAllDecisions(String decision, String justification, String principalId, String resourceId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("decision", "Edm.String", Checks.checkIsAscii(decision))
            .put("justification", "Edm.String", Checks.checkIsAscii(justification))
            .put("principalId", "Edm.String", Checks.checkIsAscii(principalId))
            .put("resourceId", "Edm.String", Checks.checkIsAscii(resourceId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recordAllDecisions"), _parameters);
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessReviewInstanceDecisionItem> filterByCurrentUser(AccessReviewInstanceDecisionItemFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.accessReviewInstanceDecisionItemFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AccessReviewInstanceDecisionItem.class, _parameters);
    }

}
