package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewHistoryDefinition;
import odata.msgraph.client.beta.entity.request.AccessReviewHistoryDefinitionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewHistoryInstanceRequest;

public class AccessReviewHistoryDefinitionCollectionRequest extends CollectionPageEntityRequest<AccessReviewHistoryDefinition, AccessReviewHistoryDefinitionRequest>{

    protected ContextPath contextPath;

    public AccessReviewHistoryDefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessReviewHistoryDefinition.class, cp -> new AccessReviewHistoryDefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessReviewHistoryInstanceRequest instances(String id) {
        return new AccessReviewHistoryInstanceRequest(contextPath.addSegment("instances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewHistoryInstanceCollectionRequest instances() {
        return new AccessReviewHistoryInstanceCollectionRequest(contextPath.addSegment("instances"), Optional.empty());
    }

}
