package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackage;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentPolicyRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleScopeRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.enums.AccessPackageFilterByCurrentUserOptions;

public class AccessPackageCollectionRequest extends CollectionPageEntityRequest<AccessPackage, AccessPackageRequest>{

    protected ContextPath contextPath;

    public AccessPackageCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessPackage.class, cp -> new AccessPackageRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessPackageAssignmentPolicyRequest accessPackageAssignmentPolicies(String id) {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentPolicyCollectionRequest accessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(contextPath.addSegment("accessPackageAssignmentPolicies"), Optional.empty());
    }

    public AccessPackageResourceRoleScopeRequest accessPackageResourceRoleScopes(String id) {
        return new AccessPackageResourceRoleScopeRequest(contextPath.addSegment("accessPackageResourceRoleScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRoleScopeCollectionRequest accessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(contextPath.addSegment("accessPackageResourceRoleScopes"), Optional.empty());
    }

    public AccessPackageRequest accessPackagesIncompatibleWith(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackagesIncompatibleWith").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCollectionRequest accessPackagesIncompatibleWith() {
        return new AccessPackageCollectionRequest(contextPath.addSegment("accessPackagesIncompatibleWith"), Optional.empty());
    }

    public AccessPackageRequest incompatibleAccessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("incompatibleAccessPackages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCollectionRequest incompatibleAccessPackages() {
        return new AccessPackageCollectionRequest(contextPath.addSegment("incompatibleAccessPackages"), Optional.empty());
    }

    public GroupRequest incompatibleGroups(String id) {
        return new GroupRequest(contextPath.addSegment("incompatibleGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest incompatibleGroups() {
        return new GroupCollectionRequest(contextPath.addSegment("incompatibleGroups"), Optional.empty());
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackage> filterByCurrentUser(AccessPackageFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.accessPackageFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AccessPackage.class, _parameters);
    }

    @Function(name = "Search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackage> search() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Search"), AccessPackage.class, _parameters);
    }

}
