package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageCatalog;
import odata.msgraph.client.beta.entity.request.AccessPackageCatalogRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceScopeRequest;
import odata.msgraph.client.beta.entity.request.CustomAccessPackageWorkflowExtensionRequest;

public class AccessPackageCatalogCollectionRequest extends CollectionPageEntityRequest<AccessPackageCatalog, AccessPackageCatalogRequest>{

    protected ContextPath contextPath;

    public AccessPackageCatalogCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessPackageCatalog.class, cp -> new AccessPackageCatalogRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(contextPath.addSegment("accessPackageResourceRoles"), Optional.empty());
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(contextPath.addSegment("accessPackageResources"), Optional.empty());
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(contextPath.addSegment("accessPackageResourceScopes"), Optional.empty());
    }

    public AccessPackageRequest accessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCollectionRequest accessPackages() {
        return new AccessPackageCollectionRequest(contextPath.addSegment("accessPackages"), Optional.empty());
    }

    public CustomAccessPackageWorkflowExtensionRequest customAccessPackageWorkflowExtensions(String id) {
        return new CustomAccessPackageWorkflowExtensionRequest(contextPath.addSegment("customAccessPackageWorkflowExtensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomAccessPackageWorkflowExtensionCollectionRequest customAccessPackageWorkflowExtensions() {
        return new CustomAccessPackageWorkflowExtensionCollectionRequest(contextPath.addSegment("customAccessPackageWorkflowExtensions"), Optional.empty());
    }

    @Function(name = "Search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageCatalog> search() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Search"), AccessPackageCatalog.class, _parameters);
    }

}
