package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentPolicy;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentPolicyRequest;
import odata.msgraph.client.beta.entity.request.CustomExtensionHandlerRequest;

public class AccessPackageAssignmentPolicyCollectionRequest extends CollectionPageEntityRequest<AccessPackageAssignmentPolicy, AccessPackageAssignmentPolicyRequest>{

    protected ContextPath contextPath;

    public AccessPackageAssignmentPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessPackageAssignmentPolicy.class, cp -> new AccessPackageAssignmentPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CustomExtensionHandlerRequest customExtensionHandlers(String id) {
        return new CustomExtensionHandlerRequest(contextPath.addSegment("customExtensionHandlers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomExtensionHandlerCollectionRequest customExtensionHandlers() {
        return new CustomExtensionHandlerCollectionRequest(contextPath.addSegment("customExtensionHandlers"), Optional.empty());
    }

}
