package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.X509CertificateAuthenticationModeConfiguration;
import odata.msgraph.client.beta.complex.X509CertificateUserBinding;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodTargetCollectionRequest;
import odata.msgraph.client.beta.enums.AuthenticationMethodState;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationModeConfiguration", 
    "certificateUserBindings", 
    "includeTargets"})
@JsonInclude(Include.NON_NULL)
public class X509CertificateAuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.x509CertificateAuthenticationMethodConfiguration";
    }

    @JsonProperty("authenticationModeConfiguration")
    protected X509CertificateAuthenticationModeConfiguration authenticationModeConfiguration;

    @JsonProperty("certificateUserBindings")
    protected List<X509CertificateUserBinding> certificateUserBindings;

    @JsonProperty("certificateUserBindings@nextLink")
    protected String certificateUserBindingsNextLink;

    @JsonProperty("includeTargets")
    protected List<AuthenticationMethodTarget> includeTargets;

    protected X509CertificateAuthenticationMethodConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderX509CertificateAuthenticationMethodConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AuthenticationMethodState state;
        private X509CertificateAuthenticationModeConfiguration authenticationModeConfiguration;
        private List<X509CertificateUserBinding> certificateUserBindings;
        private String certificateUserBindingsNextLink;
        private List<AuthenticationMethodTarget> includeTargets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder state(AuthenticationMethodState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder authenticationModeConfiguration(X509CertificateAuthenticationModeConfiguration authenticationModeConfiguration) {
            this.authenticationModeConfiguration = authenticationModeConfiguration;
            this.changedFields = changedFields.add("authenticationModeConfiguration");
            return this;
        }

        public Builder certificateUserBindings(List<X509CertificateUserBinding> certificateUserBindings) {
            this.certificateUserBindings = certificateUserBindings;
            this.changedFields = changedFields.add("certificateUserBindings");
            return this;
        }

        public Builder certificateUserBindings(X509CertificateUserBinding... certificateUserBindings) {
            return certificateUserBindings(Arrays.asList(certificateUserBindings));
        }

        public Builder certificateUserBindingsNextLink(String certificateUserBindingsNextLink) {
            this.certificateUserBindingsNextLink = certificateUserBindingsNextLink;
            this.changedFields = changedFields.add("certificateUserBindings");
            return this;
        }

        public Builder includeTargets(List<AuthenticationMethodTarget> includeTargets) {
            this.includeTargets = includeTargets;
            this.changedFields = changedFields.add("includeTargets");
            return this;
        }

        public Builder includeTargets(AuthenticationMethodTarget... includeTargets) {
            return includeTargets(Arrays.asList(includeTargets));
        }

        public X509CertificateAuthenticationMethodConfiguration build() {
            X509CertificateAuthenticationMethodConfiguration _x = new X509CertificateAuthenticationMethodConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.x509CertificateAuthenticationMethodConfiguration";
            _x.id = id;
            _x.state = state;
            _x.authenticationModeConfiguration = authenticationModeConfiguration;
            _x.certificateUserBindings = certificateUserBindings;
            _x.certificateUserBindingsNextLink = certificateUserBindingsNextLink;
            _x.includeTargets = includeTargets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authenticationModeConfiguration")
    @JsonIgnore
    public Optional<X509CertificateAuthenticationModeConfiguration> getAuthenticationModeConfiguration() {
        return Optional.ofNullable(authenticationModeConfiguration);
    }

    public X509CertificateAuthenticationMethodConfiguration withAuthenticationModeConfiguration(X509CertificateAuthenticationModeConfiguration authenticationModeConfiguration) {
        X509CertificateAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationModeConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateAuthenticationMethodConfiguration");
        _x.authenticationModeConfiguration = authenticationModeConfiguration;
        return _x;
    }

    @Property(name="certificateUserBindings")
    @JsonIgnore
    public CollectionPage<X509CertificateUserBinding> getCertificateUserBindings() {
        return new CollectionPage<X509CertificateUserBinding>(contextPath, X509CertificateUserBinding.class, this.certificateUserBindings, Optional.ofNullable(certificateUserBindingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public X509CertificateAuthenticationMethodConfiguration withCertificateUserBindings(List<X509CertificateUserBinding> certificateUserBindings) {
        X509CertificateAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("certificateUserBindings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateAuthenticationMethodConfiguration");
        _x.certificateUserBindings = certificateUserBindings;
        return _x;
    }

    @Property(name="certificateUserBindings")
    @JsonIgnore
    public CollectionPage<X509CertificateUserBinding> getCertificateUserBindings(HttpRequestOptions options) {
        return new CollectionPage<X509CertificateUserBinding>(contextPath, X509CertificateUserBinding.class, this.certificateUserBindings, Optional.ofNullable(certificateUserBindingsNextLink), Collections.emptyList(), options);
    }

    public X509CertificateAuthenticationMethodConfiguration withUnmappedField(String name, Object value) {
        X509CertificateAuthenticationMethodConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="includeTargets")
    @JsonIgnore
    public AuthenticationMethodTargetCollectionRequest getIncludeTargets() {
        return new AuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.ofNullable(includeTargets));
    }

    public X509CertificateAuthenticationMethodConfiguration withIncludeTargets(List<AuthenticationMethodTarget> includeTargets) {
        X509CertificateAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("includeTargets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateAuthenticationMethodConfiguration");
        _x.includeTargets = includeTargets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public X509CertificateAuthenticationMethodConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        X509CertificateAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public X509CertificateAuthenticationMethodConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        X509CertificateAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private X509CertificateAuthenticationMethodConfiguration _copy() {
        X509CertificateAuthenticationMethodConfiguration _x = new X509CertificateAuthenticationMethodConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.state = state;
        _x.authenticationModeConfiguration = authenticationModeConfiguration;
        _x.certificateUserBindings = certificateUserBindings;
        _x.includeTargets = includeTargets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("X509CertificateAuthenticationMethodConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("authenticationModeConfiguration=");
        b.append(this.authenticationModeConfiguration);
        b.append(", ");
        b.append("certificateUserBindings=");
        b.append(this.certificateUserBindings);
        b.append(", ");
        b.append("includeTargets=");
        b.append(this.includeTargets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
