package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.WorkforceIntegrationEncryption;
import odata.msgraph.client.beta.enums.EligibilityFilteringEnabledEntities;
import odata.msgraph.client.beta.enums.WorkforceIntegrationSupportedEntities;

@JsonPropertyOrder({
    "@odata.type", 
    "apiVersion", 
    "displayName", 
    "eligibilityFilteringEnabledEntities", 
    "encryption", 
    "isActive", 
    "supportedEntities", 
    "supports", 
    "url"})
@JsonInclude(Include.NON_NULL)
public class WorkforceIntegration extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workforceIntegration";
    }

    @JsonProperty("apiVersion")
    protected Integer apiVersion;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("eligibilityFilteringEnabledEntities")
    protected EligibilityFilteringEnabledEntities eligibilityFilteringEnabledEntities;

    @JsonProperty("encryption")
    protected WorkforceIntegrationEncryption encryption;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("supportedEntities")
    protected WorkforceIntegrationSupportedEntities supportedEntities;

    @JsonProperty("supports")
    protected WorkforceIntegrationSupportedEntities supports;

    @JsonProperty("url")
    protected String url;

    protected WorkforceIntegration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkforceIntegration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private Integer apiVersion;
        private String displayName;
        private EligibilityFilteringEnabledEntities eligibilityFilteringEnabledEntities;
        private WorkforceIntegrationEncryption encryption;
        private Boolean isActive;
        private WorkforceIntegrationSupportedEntities supportedEntities;
        private WorkforceIntegrationSupportedEntities supports;
        private String url;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder apiVersion(Integer apiVersion) {
            this.apiVersion = apiVersion;
            this.changedFields = changedFields.add("apiVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder eligibilityFilteringEnabledEntities(EligibilityFilteringEnabledEntities eligibilityFilteringEnabledEntities) {
            this.eligibilityFilteringEnabledEntities = eligibilityFilteringEnabledEntities;
            this.changedFields = changedFields.add("eligibilityFilteringEnabledEntities");
            return this;
        }

        public Builder encryption(WorkforceIntegrationEncryption encryption) {
            this.encryption = encryption;
            this.changedFields = changedFields.add("encryption");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder supportedEntities(WorkforceIntegrationSupportedEntities supportedEntities) {
            this.supportedEntities = supportedEntities;
            this.changedFields = changedFields.add("supportedEntities");
            return this;
        }

        public Builder supports(WorkforceIntegrationSupportedEntities supports) {
            this.supports = supports;
            this.changedFields = changedFields.add("supports");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public WorkforceIntegration build() {
            WorkforceIntegration _x = new WorkforceIntegration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workforceIntegration";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.apiVersion = apiVersion;
            _x.displayName = displayName;
            _x.eligibilityFilteringEnabledEntities = eligibilityFilteringEnabledEntities;
            _x.encryption = encryption;
            _x.isActive = isActive;
            _x.supportedEntities = supportedEntities;
            _x.supports = supports;
            _x.url = url;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="apiVersion")
    @JsonIgnore
    public Optional<Integer> getApiVersion() {
        return Optional.ofNullable(apiVersion);
    }

    public WorkforceIntegration withApiVersion(Integer apiVersion) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("apiVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.apiVersion = apiVersion;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public WorkforceIntegration withDisplayName(String displayName) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="eligibilityFilteringEnabledEntities")
    @JsonIgnore
    public Optional<EligibilityFilteringEnabledEntities> getEligibilityFilteringEnabledEntities() {
        return Optional.ofNullable(eligibilityFilteringEnabledEntities);
    }

    public WorkforceIntegration withEligibilityFilteringEnabledEntities(EligibilityFilteringEnabledEntities eligibilityFilteringEnabledEntities) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("eligibilityFilteringEnabledEntities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.eligibilityFilteringEnabledEntities = eligibilityFilteringEnabledEntities;
        return _x;
    }

    @Property(name="encryption")
    @JsonIgnore
    public Optional<WorkforceIntegrationEncryption> getEncryption() {
        return Optional.ofNullable(encryption);
    }

    public WorkforceIntegration withEncryption(WorkforceIntegrationEncryption encryption) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("encryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.encryption = encryption;
        return _x;
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public WorkforceIntegration withIsActive(Boolean isActive) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("isActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="supportedEntities")
    @JsonIgnore
    public Optional<WorkforceIntegrationSupportedEntities> getSupportedEntities() {
        return Optional.ofNullable(supportedEntities);
    }

    public WorkforceIntegration withSupportedEntities(WorkforceIntegrationSupportedEntities supportedEntities) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("supportedEntities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.supportedEntities = supportedEntities;
        return _x;
    }

    @Property(name="supports")
    @JsonIgnore
    public Optional<WorkforceIntegrationSupportedEntities> getSupports() {
        return Optional.ofNullable(supports);
    }

    public WorkforceIntegration withSupports(WorkforceIntegrationSupportedEntities supports) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("supports");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.supports = supports;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public WorkforceIntegration withUrl(String url) {
        WorkforceIntegration _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegration");
        _x.url = url;
        return _x;
    }

    public WorkforceIntegration withUnmappedField(String name, Object value) {
        WorkforceIntegration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkforceIntegration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkforceIntegration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkforceIntegration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkforceIntegration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkforceIntegration _copy() {
        WorkforceIntegration _x = new WorkforceIntegration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.apiVersion = apiVersion;
        _x.displayName = displayName;
        _x.eligibilityFilteringEnabledEntities = eligibilityFilteringEnabledEntities;
        _x.encryption = encryption;
        _x.isActive = isActive;
        _x.supportedEntities = supportedEntities;
        _x.supports = supports;
        _x.url = url;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkforceIntegration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("apiVersion=");
        b.append(this.apiVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("eligibilityFilteringEnabledEntities=");
        b.append(this.eligibilityFilteringEnabledEntities);
        b.append(", ");
        b.append("encryption=");
        b.append(this.encryption);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("supportedEntities=");
        b.append(this.supportedEntities);
        b.append(", ");
        b.append("supports=");
        b.append(this.supports);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
