package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.WorkbookWorksheetProtectionOptions;

@JsonPropertyOrder({
    "@odata.type", 
    "options", 
    "protected"})
@JsonInclude(Include.NON_NULL)
public class WorkbookWorksheetProtection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookWorksheetProtection";
    }

    @JsonProperty("options")
    protected WorkbookWorksheetProtectionOptions options;

    @JsonProperty("protected")
    protected Boolean protected_;

    protected WorkbookWorksheetProtection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookWorksheetProtection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WorkbookWorksheetProtectionOptions options;
        private Boolean protected_;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder options(WorkbookWorksheetProtectionOptions options) {
            this.options = options;
            this.changedFields = changedFields.add("options");
            return this;
        }

        public Builder protected_(Boolean protected_) {
            this.protected_ = protected_;
            this.changedFields = changedFields.add("protected");
            return this;
        }

        public WorkbookWorksheetProtection build() {
            WorkbookWorksheetProtection _x = new WorkbookWorksheetProtection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookWorksheetProtection";
            _x.id = id;
            _x.options = options;
            _x.protected_ = protected_;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="options")
    @JsonIgnore
    public Optional<WorkbookWorksheetProtectionOptions> getOptions() {
        return Optional.ofNullable(options);
    }

    public WorkbookWorksheetProtection withOptions(WorkbookWorksheetProtectionOptions options) {
        WorkbookWorksheetProtection _x = _copy();
        _x.changedFields = changedFields.add("options");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtection");
        _x.options = options;
        return _x;
    }

    @Property(name="protected")
    @JsonIgnore
    public Optional<Boolean> getProtected() {
        return Optional.ofNullable(protected_);
    }

    public WorkbookWorksheetProtection withProtected(Boolean protected_) {
        WorkbookWorksheetProtection _x = _copy();
        _x.changedFields = changedFields.add("protected");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtection");
        _x.protected_ = protected_;
        return _x;
    }

    public WorkbookWorksheetProtection withUnmappedField(String name, Object value) {
        WorkbookWorksheetProtection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookWorksheetProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookWorksheetProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookWorksheetProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookWorksheetProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookWorksheetProtection _copy() {
        WorkbookWorksheetProtection _x = new WorkbookWorksheetProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.options = options;
        _x.protected_ = protected_;
        return _x;
    }

    @Action(name = "protect")
    @JsonIgnore
    public ActionRequestNoReturn protect(WorkbookWorksheetProtectionOptions options) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("options", "microsoft.graph.workbookWorksheetProtectionOptions", options)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.protect"), _parameters);
    }

    @Action(name = "unprotect")
    @JsonIgnore
    public ActionRequestNoReturn unprotect() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unprotect"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookWorksheetProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("options=");
        b.append(this.options);
        b.append(", ");
        b.append("protected=");
        b.append(this.protected_);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
