package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WorkbookChartCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookNamedItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookPivotTableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableCollectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookWorksheetProtectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "position", 
    "visibility", 
    "charts", 
    "names", 
    "pivotTables", 
    "protection", 
    "tables"})
@JsonInclude(Include.NON_NULL)
public class WorkbookWorksheet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookWorksheet";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("position")
    protected Integer position;

    @JsonProperty("visibility")
    protected String visibility;

    @JsonProperty("charts")
    protected List<WorkbookChart> charts;

    @JsonProperty("names")
    protected List<WorkbookNamedItem> names;

    @JsonProperty("pivotTables")
    protected List<WorkbookPivotTable> pivotTables;

    @JsonProperty("protection")
    protected WorkbookWorksheetProtection protection;

    @JsonProperty("tables")
    protected List<WorkbookTable> tables;

    protected WorkbookWorksheet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookWorksheet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private Integer position;
        private String visibility;
        private List<WorkbookChart> charts;
        private List<WorkbookNamedItem> names;
        private List<WorkbookPivotTable> pivotTables;
        private WorkbookWorksheetProtection protection;
        private List<WorkbookTable> tables;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder position(Integer position) {
            this.position = position;
            this.changedFields = changedFields.add("position");
            return this;
        }

        public Builder visibility(String visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        public Builder charts(List<WorkbookChart> charts) {
            this.charts = charts;
            this.changedFields = changedFields.add("charts");
            return this;
        }

        public Builder charts(WorkbookChart... charts) {
            return charts(Arrays.asList(charts));
        }

        public Builder names(List<WorkbookNamedItem> names) {
            this.names = names;
            this.changedFields = changedFields.add("names");
            return this;
        }

        public Builder names(WorkbookNamedItem... names) {
            return names(Arrays.asList(names));
        }

        public Builder pivotTables(List<WorkbookPivotTable> pivotTables) {
            this.pivotTables = pivotTables;
            this.changedFields = changedFields.add("pivotTables");
            return this;
        }

        public Builder pivotTables(WorkbookPivotTable... pivotTables) {
            return pivotTables(Arrays.asList(pivotTables));
        }

        public Builder protection(WorkbookWorksheetProtection protection) {
            this.protection = protection;
            this.changedFields = changedFields.add("protection");
            return this;
        }

        public Builder tables(List<WorkbookTable> tables) {
            this.tables = tables;
            this.changedFields = changedFields.add("tables");
            return this;
        }

        public Builder tables(WorkbookTable... tables) {
            return tables(Arrays.asList(tables));
        }

        public WorkbookWorksheet build() {
            WorkbookWorksheet _x = new WorkbookWorksheet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookWorksheet";
            _x.id = id;
            _x.name = name;
            _x.position = position;
            _x.visibility = visibility;
            _x.charts = charts;
            _x.names = names;
            _x.pivotTables = pivotTables;
            _x.protection = protection;
            _x.tables = tables;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WorkbookWorksheet withName(String name) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.name = name;
        return _x;
    }

    @Property(name="position")
    @JsonIgnore
    public Optional<Integer> getPosition() {
        return Optional.ofNullable(position);
    }

    public WorkbookWorksheet withPosition(Integer position) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("position");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.position = position;
        return _x;
    }

    @Property(name="visibility")
    @JsonIgnore
    public Optional<String> getVisibility() {
        return Optional.ofNullable(visibility);
    }

    public WorkbookWorksheet withVisibility(String visibility) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("visibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.visibility = visibility;
        return _x;
    }

    public WorkbookWorksheet withUnmappedField(String name, Object value) {
        WorkbookWorksheet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="charts")
    @JsonIgnore
    public WorkbookChartCollectionRequest getCharts() {
        return new WorkbookChartCollectionRequest(
                        contextPath.addSegment("charts"), Optional.ofNullable(charts));
    }

    @NavigationProperty(name="names")
    @JsonIgnore
    public WorkbookNamedItemCollectionRequest getNames() {
        return new WorkbookNamedItemCollectionRequest(
                        contextPath.addSegment("names"), Optional.ofNullable(names));
    }

    @NavigationProperty(name="pivotTables")
    @JsonIgnore
    public WorkbookPivotTableCollectionRequest getPivotTables() {
        return new WorkbookPivotTableCollectionRequest(
                        contextPath.addSegment("pivotTables"), Optional.ofNullable(pivotTables));
    }

    @NavigationProperty(name="protection")
    @JsonIgnore
    public WorkbookWorksheetProtectionRequest getProtection() {
        return new WorkbookWorksheetProtectionRequest(contextPath.addSegment("protection"), Optional.ofNullable(protection));
    }

    @NavigationProperty(name="tables")
    @JsonIgnore
    public WorkbookTableCollectionRequest getTables() {
        return new WorkbookTableCollectionRequest(
                        contextPath.addSegment("tables"), Optional.ofNullable(tables));
    }

    public WorkbookWorksheet withCharts(List<WorkbookChart> charts) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("charts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.charts = charts;
        return _x;
    }

    public WorkbookWorksheet withNames(List<WorkbookNamedItem> names) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("names");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.names = names;
        return _x;
    }

    public WorkbookWorksheet withPivotTables(List<WorkbookPivotTable> pivotTables) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("pivotTables");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.pivotTables = pivotTables;
        return _x;
    }

    public WorkbookWorksheet withProtection(WorkbookWorksheetProtection protection) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("protection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.protection = protection;
        return _x;
    }

    public WorkbookWorksheet withTables(List<WorkbookTable> tables) {
        WorkbookWorksheet _x = _copy();
        _x.changedFields = changedFields.add("tables");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheet");
        _x.tables = tables;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookWorksheet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookWorksheet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookWorksheet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookWorksheet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookWorksheet _copy() {
        WorkbookWorksheet _x = new WorkbookWorksheet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.position = position;
        _x.visibility = visibility;
        _x.charts = charts;
        _x.names = names;
        _x.pivotTables = pivotTables;
        _x.protection = protection;
        _x.tables = tables;
        return _x;
    }

    @Function(name = "cell")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> cell(Integer row, Integer column) {
        Preconditions.checkNotNull(row, "row cannot be null");
        Preconditions.checkNotNull(column, "column cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("row", "Edm.Int32", row)
            .put("column", "Edm.Int32", column)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cell"), WorkbookRange.class, _parameters);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange_Function(Boolean valuesOnly) {
        Preconditions.checkNotNull(valuesOnly, "valuesOnly cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("valuesOnly", "Edm.Boolean", valuesOnly)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters);
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range_Function(String address) {
        Preconditions.checkNotNull(address, "address cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("address", "Edm.String", Checks.checkIsAscii(address))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookWorksheet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("position=");
        b.append(this.position);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("charts=");
        b.append(this.charts);
        b.append(", ");
        b.append("names=");
        b.append(this.names);
        b.append(", ");
        b.append("pivotTables=");
        b.append(this.pivotTables);
        b.append(", ");
        b.append("protection=");
        b.append(this.protection);
        b.append(", ");
        b.append("tables=");
        b.append(this.tables);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
