package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.WorkbookSortField;

@JsonPropertyOrder({
    "@odata.type", 
    "fields", 
    "matchCase", 
    "method"})
@JsonInclude(Include.NON_NULL)
public class WorkbookTableSort extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookTableSort";
    }

    @JsonProperty("fields")
    protected List<WorkbookSortField> fields;

    @JsonProperty("fields@nextLink")
    protected String fieldsNextLink;

    @JsonProperty("matchCase")
    protected Boolean matchCase;

    @JsonProperty("method")
    protected String method;

    protected WorkbookTableSort() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookTableSort() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<WorkbookSortField> fields;
        private String fieldsNextLink;
        private Boolean matchCase;
        private String method;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder fields(List<WorkbookSortField> fields) {
            this.fields = fields;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder fields(WorkbookSortField... fields) {
            return fields(Arrays.asList(fields));
        }

        public Builder fieldsNextLink(String fieldsNextLink) {
            this.fieldsNextLink = fieldsNextLink;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder matchCase(Boolean matchCase) {
            this.matchCase = matchCase;
            this.changedFields = changedFields.add("matchCase");
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            this.changedFields = changedFields.add("method");
            return this;
        }

        public WorkbookTableSort build() {
            WorkbookTableSort _x = new WorkbookTableSort();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookTableSort";
            _x.id = id;
            _x.fields = fields;
            _x.fieldsNextLink = fieldsNextLink;
            _x.matchCase = matchCase;
            _x.method = method;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<WorkbookSortField> getFields() {
        return new CollectionPage<WorkbookSortField>(contextPath, WorkbookSortField.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public WorkbookTableSort withFields(List<WorkbookSortField> fields) {
        WorkbookTableSort _x = _copy();
        _x.changedFields = changedFields.add("fields");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableSort");
        _x.fields = fields;
        return _x;
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<WorkbookSortField> getFields(HttpRequestOptions options) {
        return new CollectionPage<WorkbookSortField>(contextPath, WorkbookSortField.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), options);
    }

    @Property(name="matchCase")
    @JsonIgnore
    public Optional<Boolean> getMatchCase() {
        return Optional.ofNullable(matchCase);
    }

    public WorkbookTableSort withMatchCase(Boolean matchCase) {
        WorkbookTableSort _x = _copy();
        _x.changedFields = changedFields.add("matchCase");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableSort");
        _x.matchCase = matchCase;
        return _x;
    }

    @Property(name="method")
    @JsonIgnore
    public Optional<String> getMethod() {
        return Optional.ofNullable(method);
    }

    public WorkbookTableSort withMethod(String method) {
        WorkbookTableSort _x = _copy();
        _x.changedFields = changedFields.add("method");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableSort");
        _x.method = method;
        return _x;
    }

    public WorkbookTableSort withUnmappedField(String name, Object value) {
        WorkbookTableSort _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTableSort patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookTableSort _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTableSort put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookTableSort _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookTableSort _copy() {
        WorkbookTableSort _x = new WorkbookTableSort();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.fields = fields;
        _x.matchCase = matchCase;
        _x.method = method;
        return _x;
    }

    @Action(name = "apply")
    @JsonIgnore
    public ActionRequestNoReturn apply(List<WorkbookSortField> fields, Boolean matchCase, String method) {
        Preconditions.checkNotNull(matchCase, "matchCase cannot be null");
        Preconditions.checkNotNull(method, "method cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fields", "Collection(microsoft.graph.workbookSortField)", fields)
            .put("matchCase", "Edm.Boolean", matchCase)
            .put("method", "Edm.String", Checks.checkIsAscii(method))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.apply"), _parameters);
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

    @Action(name = "reapply")
    @JsonIgnore
    public ActionRequestNoReturn reapply() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reapply"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookTableSort[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("fields=");
        b.append(this.fields);
        b.append(", ");
        b.append("matchCase=");
        b.append(this.matchCase);
        b.append(", ");
        b.append("method=");
        b.append(this.method);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
