package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;

@JsonPropertyOrder({
    "@odata.type", 
    "index", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class WorkbookTableRow extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookTableRow";
    }

    @JsonProperty("index")
    protected Integer index;

    @JsonProperty("values")
    protected Json values;

    protected WorkbookTableRow() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookTableRow() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer index;
        private Json values;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder index(Integer index) {
            this.index = index;
            this.changedFields = changedFields.add("index");
            return this;
        }

        public Builder values(Json values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public WorkbookTableRow build() {
            WorkbookTableRow _x = new WorkbookTableRow();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookTableRow";
            _x.id = id;
            _x.index = index;
            _x.values = values;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="index")
    @JsonIgnore
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    public WorkbookTableRow withIndex(Integer index) {
        WorkbookTableRow _x = _copy();
        _x.changedFields = changedFields.add("index");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableRow");
        _x.index = index;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public Optional<Json> getValues() {
        return Optional.ofNullable(values);
    }

    public WorkbookTableRow withValues(Json values) {
        WorkbookTableRow _x = _copy();
        _x.changedFields = changedFields.add("values");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableRow");
        _x.values = values;
        return _x;
    }

    public WorkbookTableRow withUnmappedField(String name, Object value) {
        WorkbookTableRow _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTableRow patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookTableRow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTableRow put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookTableRow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookTableRow _copy() {
        WorkbookTableRow _x = new WorkbookTableRow();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.index = index;
        _x.values = values;
        return _x;
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookTableRow[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("index=");
        b.append(this.index);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
