package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.collection.request.WorkbookRangeViewCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "cellAddresses", 
    "columnCount", 
    "formulas", 
    "formulasLocal", 
    "formulasR1C1", 
    "index", 
    "numberFormat", 
    "rowCount", 
    "text", 
    "values", 
    "valueTypes", 
    "rows"})
@JsonInclude(Include.NON_NULL)
public class WorkbookRangeView extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookRangeView";
    }

    @JsonProperty("cellAddresses")
    protected Json cellAddresses;

    @JsonProperty("columnCount")
    protected Integer columnCount;

    @JsonProperty("formulas")
    protected Json formulas;

    @JsonProperty("formulasLocal")
    protected Json formulasLocal;

    @JsonProperty("formulasR1C1")
    protected Json formulasR1C1;

    @JsonProperty("index")
    protected Integer index;

    @JsonProperty("numberFormat")
    protected Json numberFormat;

    @JsonProperty("rowCount")
    protected Integer rowCount;

    @JsonProperty("text")
    protected Json text;

    @JsonProperty("values")
    protected Json values;

    @JsonProperty("valueTypes")
    protected Json valueTypes;

    @JsonProperty("rows")
    protected List<WorkbookRangeView> rows;

    protected WorkbookRangeView() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookRangeView() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Json cellAddresses;
        private Integer columnCount;
        private Json formulas;
        private Json formulasLocal;
        private Json formulasR1C1;
        private Integer index;
        private Json numberFormat;
        private Integer rowCount;
        private Json text;
        private Json values;
        private Json valueTypes;
        private List<WorkbookRangeView> rows;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder cellAddresses(Json cellAddresses) {
            this.cellAddresses = cellAddresses;
            this.changedFields = changedFields.add("cellAddresses");
            return this;
        }

        public Builder columnCount(Integer columnCount) {
            this.columnCount = columnCount;
            this.changedFields = changedFields.add("columnCount");
            return this;
        }

        public Builder formulas(Json formulas) {
            this.formulas = formulas;
            this.changedFields = changedFields.add("formulas");
            return this;
        }

        public Builder formulasLocal(Json formulasLocal) {
            this.formulasLocal = formulasLocal;
            this.changedFields = changedFields.add("formulasLocal");
            return this;
        }

        public Builder formulasR1C1(Json formulasR1C1) {
            this.formulasR1C1 = formulasR1C1;
            this.changedFields = changedFields.add("formulasR1C1");
            return this;
        }

        public Builder index(Integer index) {
            this.index = index;
            this.changedFields = changedFields.add("index");
            return this;
        }

        public Builder numberFormat(Json numberFormat) {
            this.numberFormat = numberFormat;
            this.changedFields = changedFields.add("numberFormat");
            return this;
        }

        public Builder rowCount(Integer rowCount) {
            this.rowCount = rowCount;
            this.changedFields = changedFields.add("rowCount");
            return this;
        }

        public Builder text(Json text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder values(Json values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public Builder valueTypes(Json valueTypes) {
            this.valueTypes = valueTypes;
            this.changedFields = changedFields.add("valueTypes");
            return this;
        }

        public Builder rows(List<WorkbookRangeView> rows) {
            this.rows = rows;
            this.changedFields = changedFields.add("rows");
            return this;
        }

        public Builder rows(WorkbookRangeView... rows) {
            return rows(Arrays.asList(rows));
        }

        public WorkbookRangeView build() {
            WorkbookRangeView _x = new WorkbookRangeView();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookRangeView";
            _x.id = id;
            _x.cellAddresses = cellAddresses;
            _x.columnCount = columnCount;
            _x.formulas = formulas;
            _x.formulasLocal = formulasLocal;
            _x.formulasR1C1 = formulasR1C1;
            _x.index = index;
            _x.numberFormat = numberFormat;
            _x.rowCount = rowCount;
            _x.text = text;
            _x.values = values;
            _x.valueTypes = valueTypes;
            _x.rows = rows;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="cellAddresses")
    @JsonIgnore
    public Optional<Json> getCellAddresses() {
        return Optional.ofNullable(cellAddresses);
    }

    public WorkbookRangeView withCellAddresses(Json cellAddresses) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("cellAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.cellAddresses = cellAddresses;
        return _x;
    }

    @Property(name="columnCount")
    @JsonIgnore
    public Optional<Integer> getColumnCount() {
        return Optional.ofNullable(columnCount);
    }

    public WorkbookRangeView withColumnCount(Integer columnCount) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("columnCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.columnCount = columnCount;
        return _x;
    }

    @Property(name="formulas")
    @JsonIgnore
    public Optional<Json> getFormulas() {
        return Optional.ofNullable(formulas);
    }

    public WorkbookRangeView withFormulas(Json formulas) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("formulas");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.formulas = formulas;
        return _x;
    }

    @Property(name="formulasLocal")
    @JsonIgnore
    public Optional<Json> getFormulasLocal() {
        return Optional.ofNullable(formulasLocal);
    }

    public WorkbookRangeView withFormulasLocal(Json formulasLocal) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("formulasLocal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.formulasLocal = formulasLocal;
        return _x;
    }

    @Property(name="formulasR1C1")
    @JsonIgnore
    public Optional<Json> getFormulasR1C1() {
        return Optional.ofNullable(formulasR1C1);
    }

    public WorkbookRangeView withFormulasR1C1(Json formulasR1C1) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("formulasR1C1");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.formulasR1C1 = formulasR1C1;
        return _x;
    }

    @Property(name="index")
    @JsonIgnore
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    public WorkbookRangeView withIndex(Integer index) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("index");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.index = index;
        return _x;
    }

    @Property(name="numberFormat")
    @JsonIgnore
    public Optional<Json> getNumberFormat() {
        return Optional.ofNullable(numberFormat);
    }

    public WorkbookRangeView withNumberFormat(Json numberFormat) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("numberFormat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.numberFormat = numberFormat;
        return _x;
    }

    @Property(name="rowCount")
    @JsonIgnore
    public Optional<Integer> getRowCount() {
        return Optional.ofNullable(rowCount);
    }

    public WorkbookRangeView withRowCount(Integer rowCount) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("rowCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.rowCount = rowCount;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<Json> getText() {
        return Optional.ofNullable(text);
    }

    public WorkbookRangeView withText(Json text) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.text = text;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public Optional<Json> getValues() {
        return Optional.ofNullable(values);
    }

    public WorkbookRangeView withValues(Json values) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("values");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.values = values;
        return _x;
    }

    @Property(name="valueTypes")
    @JsonIgnore
    public Optional<Json> getValueTypes() {
        return Optional.ofNullable(valueTypes);
    }

    public WorkbookRangeView withValueTypes(Json valueTypes) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("valueTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.valueTypes = valueTypes;
        return _x;
    }

    public WorkbookRangeView withUnmappedField(String name, Object value) {
        WorkbookRangeView _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="rows")
    @JsonIgnore
    public WorkbookRangeViewCollectionRequest getRows() {
        return new WorkbookRangeViewCollectionRequest(
                        contextPath.addSegment("rows"), Optional.ofNullable(rows));
    }

    public WorkbookRangeView withRows(List<WorkbookRangeView> rows) {
        WorkbookRangeView _x = _copy();
        _x.changedFields = changedFields.add("rows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeView");
        _x.rows = rows;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRangeView patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookRangeView _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRangeView put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookRangeView _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookRangeView _copy() {
        WorkbookRangeView _x = new WorkbookRangeView();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.cellAddresses = cellAddresses;
        _x.columnCount = columnCount;
        _x.formulas = formulas;
        _x.formulasLocal = formulasLocal;
        _x.formulasR1C1 = formulasR1C1;
        _x.index = index;
        _x.numberFormat = numberFormat;
        _x.rowCount = rowCount;
        _x.text = text;
        _x.values = values;
        _x.valueTypes = valueTypes;
        _x.rows = rows;
        return _x;
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookRangeView[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("cellAddresses=");
        b.append(this.cellAddresses);
        b.append(", ");
        b.append("columnCount=");
        b.append(this.columnCount);
        b.append(", ");
        b.append("formulas=");
        b.append(this.formulas);
        b.append(", ");
        b.append("formulasLocal=");
        b.append(this.formulasLocal);
        b.append(", ");
        b.append("formulasR1C1=");
        b.append(this.formulasR1C1);
        b.append(", ");
        b.append("index=");
        b.append(this.index);
        b.append(", ");
        b.append("numberFormat=");
        b.append(this.numberFormat);
        b.append(", ");
        b.append("rowCount=");
        b.append(this.rowCount);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append(", ");
        b.append("valueTypes=");
        b.append(this.valueTypes);
        b.append(", ");
        b.append("rows=");
        b.append(this.rows);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
