package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "color"})
@JsonInclude(Include.NON_NULL)
public class WorkbookRangeFill extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookRangeFill";
    }

    @JsonProperty("color")
    protected String color;

    protected WorkbookRangeFill() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookRangeFill() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String color;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public WorkbookRangeFill build() {
            WorkbookRangeFill _x = new WorkbookRangeFill();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookRangeFill";
            _x.id = id;
            _x.color = color;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public WorkbookRangeFill withColor(String color) {
        WorkbookRangeFill _x = _copy();
        _x.changedFields = changedFields.add("color");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeFill");
        _x.color = color;
        return _x;
    }

    public WorkbookRangeFill withUnmappedField(String name, Object value) {
        WorkbookRangeFill _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRangeFill patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookRangeFill _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRangeFill put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookRangeFill _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookRangeFill _copy() {
        WorkbookRangeFill _x = new WorkbookRangeFill();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.color = color;
        return _x;
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookRangeFill[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("color=");
        b.append(this.color);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
