package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.request.WorkbookRangeFormatRequest;
import odata.msgraph.client.beta.entity.request.WorkbookRangeSortRequest;
import odata.msgraph.client.beta.entity.request.WorkbookWorksheetRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "addressLocal", 
    "cellCount", 
    "columnCount", 
    "columnHidden", 
    "columnIndex", 
    "formulas", 
    "formulasLocal", 
    "formulasR1C1", 
    "hidden", 
    "numberFormat", 
    "rowCount", 
    "rowHidden", 
    "rowIndex", 
    "text", 
    "values", 
    "valueTypes", 
    "format", 
    "sort", 
    "worksheet"})
@JsonInclude(Include.NON_NULL)
public class WorkbookRange extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookRange";
    }

    @JsonProperty("address")
    protected String address;

    @JsonProperty("addressLocal")
    protected String addressLocal;

    @JsonProperty("cellCount")
    protected Integer cellCount;

    @JsonProperty("columnCount")
    protected Integer columnCount;

    @JsonProperty("columnHidden")
    protected Boolean columnHidden;

    @JsonProperty("columnIndex")
    protected Integer columnIndex;

    @JsonProperty("formulas")
    protected Json formulas;

    @JsonProperty("formulasLocal")
    protected Json formulasLocal;

    @JsonProperty("formulasR1C1")
    protected Json formulasR1C1;

    @JsonProperty("hidden")
    protected Boolean hidden;

    @JsonProperty("numberFormat")
    protected Json numberFormat;

    @JsonProperty("rowCount")
    protected Integer rowCount;

    @JsonProperty("rowHidden")
    protected Boolean rowHidden;

    @JsonProperty("rowIndex")
    protected Integer rowIndex;

    @JsonProperty("text")
    protected Json text;

    @JsonProperty("values")
    protected Json values;

    @JsonProperty("valueTypes")
    protected Json valueTypes;

    @JsonProperty("format")
    protected WorkbookRangeFormat format;

    @JsonProperty("sort")
    protected WorkbookRangeSort sort;

    @JsonProperty("worksheet")
    protected WorkbookWorksheet worksheet;

    protected WorkbookRange() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookRange() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String address;
        private String addressLocal;
        private Integer cellCount;
        private Integer columnCount;
        private Boolean columnHidden;
        private Integer columnIndex;
        private Json formulas;
        private Json formulasLocal;
        private Json formulasR1C1;
        private Boolean hidden;
        private Json numberFormat;
        private Integer rowCount;
        private Boolean rowHidden;
        private Integer rowIndex;
        private Json text;
        private Json values;
        private Json valueTypes;
        private WorkbookRangeFormat format;
        private WorkbookRangeSort sort;
        private WorkbookWorksheet worksheet;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder addressLocal(String addressLocal) {
            this.addressLocal = addressLocal;
            this.changedFields = changedFields.add("addressLocal");
            return this;
        }

        public Builder cellCount(Integer cellCount) {
            this.cellCount = cellCount;
            this.changedFields = changedFields.add("cellCount");
            return this;
        }

        public Builder columnCount(Integer columnCount) {
            this.columnCount = columnCount;
            this.changedFields = changedFields.add("columnCount");
            return this;
        }

        public Builder columnHidden(Boolean columnHidden) {
            this.columnHidden = columnHidden;
            this.changedFields = changedFields.add("columnHidden");
            return this;
        }

        public Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            this.changedFields = changedFields.add("columnIndex");
            return this;
        }

        public Builder formulas(Json formulas) {
            this.formulas = formulas;
            this.changedFields = changedFields.add("formulas");
            return this;
        }

        public Builder formulasLocal(Json formulasLocal) {
            this.formulasLocal = formulasLocal;
            this.changedFields = changedFields.add("formulasLocal");
            return this;
        }

        public Builder formulasR1C1(Json formulasR1C1) {
            this.formulasR1C1 = formulasR1C1;
            this.changedFields = changedFields.add("formulasR1C1");
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            this.changedFields = changedFields.add("hidden");
            return this;
        }

        public Builder numberFormat(Json numberFormat) {
            this.numberFormat = numberFormat;
            this.changedFields = changedFields.add("numberFormat");
            return this;
        }

        public Builder rowCount(Integer rowCount) {
            this.rowCount = rowCount;
            this.changedFields = changedFields.add("rowCount");
            return this;
        }

        public Builder rowHidden(Boolean rowHidden) {
            this.rowHidden = rowHidden;
            this.changedFields = changedFields.add("rowHidden");
            return this;
        }

        public Builder rowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
            this.changedFields = changedFields.add("rowIndex");
            return this;
        }

        public Builder text(Json text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder values(Json values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public Builder valueTypes(Json valueTypes) {
            this.valueTypes = valueTypes;
            this.changedFields = changedFields.add("valueTypes");
            return this;
        }

        public Builder format(WorkbookRangeFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public Builder sort(WorkbookRangeSort sort) {
            this.sort = sort;
            this.changedFields = changedFields.add("sort");
            return this;
        }

        public Builder worksheet(WorkbookWorksheet worksheet) {
            this.worksheet = worksheet;
            this.changedFields = changedFields.add("worksheet");
            return this;
        }

        public WorkbookRange build() {
            WorkbookRange _x = new WorkbookRange();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookRange";
            _x.id = id;
            _x.address = address;
            _x.addressLocal = addressLocal;
            _x.cellCount = cellCount;
            _x.columnCount = columnCount;
            _x.columnHidden = columnHidden;
            _x.columnIndex = columnIndex;
            _x.formulas = formulas;
            _x.formulasLocal = formulasLocal;
            _x.formulasR1C1 = formulasR1C1;
            _x.hidden = hidden;
            _x.numberFormat = numberFormat;
            _x.rowCount = rowCount;
            _x.rowHidden = rowHidden;
            _x.rowIndex = rowIndex;
            _x.text = text;
            _x.values = values;
            _x.valueTypes = valueTypes;
            _x.format = format;
            _x.sort = sort;
            _x.worksheet = worksheet;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    public WorkbookRange withAddress(String address) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.address = address;
        return _x;
    }

    @Property(name="addressLocal")
    @JsonIgnore
    public Optional<String> getAddressLocal() {
        return Optional.ofNullable(addressLocal);
    }

    public WorkbookRange withAddressLocal(String addressLocal) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("addressLocal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.addressLocal = addressLocal;
        return _x;
    }

    @Property(name="cellCount")
    @JsonIgnore
    public Optional<Integer> getCellCount() {
        return Optional.ofNullable(cellCount);
    }

    public WorkbookRange withCellCount(Integer cellCount) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("cellCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.cellCount = cellCount;
        return _x;
    }

    @Property(name="columnCount")
    @JsonIgnore
    public Optional<Integer> getColumnCount() {
        return Optional.ofNullable(columnCount);
    }

    public WorkbookRange withColumnCount(Integer columnCount) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("columnCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.columnCount = columnCount;
        return _x;
    }

    @Property(name="columnHidden")
    @JsonIgnore
    public Optional<Boolean> getColumnHidden() {
        return Optional.ofNullable(columnHidden);
    }

    public WorkbookRange withColumnHidden(Boolean columnHidden) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("columnHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.columnHidden = columnHidden;
        return _x;
    }

    @Property(name="columnIndex")
    @JsonIgnore
    public Optional<Integer> getColumnIndex() {
        return Optional.ofNullable(columnIndex);
    }

    public WorkbookRange withColumnIndex(Integer columnIndex) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("columnIndex");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.columnIndex = columnIndex;
        return _x;
    }

    @Property(name="formulas")
    @JsonIgnore
    public Optional<Json> getFormulas() {
        return Optional.ofNullable(formulas);
    }

    public WorkbookRange withFormulas(Json formulas) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("formulas");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.formulas = formulas;
        return _x;
    }

    @Property(name="formulasLocal")
    @JsonIgnore
    public Optional<Json> getFormulasLocal() {
        return Optional.ofNullable(formulasLocal);
    }

    public WorkbookRange withFormulasLocal(Json formulasLocal) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("formulasLocal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.formulasLocal = formulasLocal;
        return _x;
    }

    @Property(name="formulasR1C1")
    @JsonIgnore
    public Optional<Json> getFormulasR1C1() {
        return Optional.ofNullable(formulasR1C1);
    }

    public WorkbookRange withFormulasR1C1(Json formulasR1C1) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("formulasR1C1");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.formulasR1C1 = formulasR1C1;
        return _x;
    }

    @Property(name="hidden")
    @JsonIgnore
    public Optional<Boolean> getHidden() {
        return Optional.ofNullable(hidden);
    }

    public WorkbookRange withHidden(Boolean hidden) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("hidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.hidden = hidden;
        return _x;
    }

    @Property(name="numberFormat")
    @JsonIgnore
    public Optional<Json> getNumberFormat() {
        return Optional.ofNullable(numberFormat);
    }

    public WorkbookRange withNumberFormat(Json numberFormat) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("numberFormat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.numberFormat = numberFormat;
        return _x;
    }

    @Property(name="rowCount")
    @JsonIgnore
    public Optional<Integer> getRowCount() {
        return Optional.ofNullable(rowCount);
    }

    public WorkbookRange withRowCount(Integer rowCount) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("rowCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.rowCount = rowCount;
        return _x;
    }

    @Property(name="rowHidden")
    @JsonIgnore
    public Optional<Boolean> getRowHidden() {
        return Optional.ofNullable(rowHidden);
    }

    public WorkbookRange withRowHidden(Boolean rowHidden) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("rowHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.rowHidden = rowHidden;
        return _x;
    }

    @Property(name="rowIndex")
    @JsonIgnore
    public Optional<Integer> getRowIndex() {
        return Optional.ofNullable(rowIndex);
    }

    public WorkbookRange withRowIndex(Integer rowIndex) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("rowIndex");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.rowIndex = rowIndex;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<Json> getText() {
        return Optional.ofNullable(text);
    }

    public WorkbookRange withText(Json text) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.text = text;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public Optional<Json> getValues() {
        return Optional.ofNullable(values);
    }

    public WorkbookRange withValues(Json values) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("values");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.values = values;
        return _x;
    }

    @Property(name="valueTypes")
    @JsonIgnore
    public Optional<Json> getValueTypes() {
        return Optional.ofNullable(valueTypes);
    }

    public WorkbookRange withValueTypes(Json valueTypes) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("valueTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.valueTypes = valueTypes;
        return _x;
    }

    public WorkbookRange withUnmappedField(String name, Object value) {
        WorkbookRange _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookRangeFormatRequest getFormat() {
        return new WorkbookRangeFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    @NavigationProperty(name="sort")
    @JsonIgnore
    public WorkbookRangeSortRequest getSort() {
        return new WorkbookRangeSortRequest(contextPath.addSegment("sort"), Optional.ofNullable(sort));
    }

    @NavigationProperty(name="worksheet")
    @JsonIgnore
    public WorkbookWorksheetRequest getWorksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"), Optional.ofNullable(worksheet));
    }

    public WorkbookRange withFormat(WorkbookRangeFormat format) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.format = format;
        return _x;
    }

    public WorkbookRange withSort(WorkbookRangeSort sort) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("sort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.sort = sort;
        return _x;
    }

    public WorkbookRange withWorksheet(WorkbookWorksheet worksheet) {
        WorkbookRange _x = _copy();
        _x.changedFields = changedFields.add("worksheet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRange");
        _x.worksheet = worksheet;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRange patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookRange _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRange put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookRange _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookRange _copy() {
        WorkbookRange _x = new WorkbookRange();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.address = address;
        _x.addressLocal = addressLocal;
        _x.cellCount = cellCount;
        _x.columnCount = columnCount;
        _x.columnHidden = columnHidden;
        _x.columnIndex = columnIndex;
        _x.formulas = formulas;
        _x.formulasLocal = formulasLocal;
        _x.formulasR1C1 = formulasR1C1;
        _x.hidden = hidden;
        _x.numberFormat = numberFormat;
        _x.rowCount = rowCount;
        _x.rowHidden = rowHidden;
        _x.rowIndex = rowIndex;
        _x.text = text;
        _x.values = values;
        _x.valueTypes = valueTypes;
        _x.format = format;
        _x.sort = sort;
        _x.worksheet = worksheet;
        return _x;
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear(String applyTo) {
        Preconditions.checkNotNull(applyTo, "applyTo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("applyTo", "Edm.String", Checks.checkIsAscii(applyTo))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

    @Action(name = "delete")
    @JsonIgnore
    public ActionRequestNoReturn delete(String shift) {
        Preconditions.checkNotNull(shift, "shift cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("shift", "Edm.String", Checks.checkIsAscii(shift))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delete"), _parameters);
    }

    @Action(name = "insert")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookRange> insert(String shift) {
        Preconditions.checkNotNull(shift, "shift cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("shift", "Edm.String", Checks.checkIsAscii(shift))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.insert"), WorkbookRange.class, _parameters);
    }

    @Action(name = "merge")
    @JsonIgnore
    public ActionRequestNoReturn merge(Boolean across) {
        Preconditions.checkNotNull(across, "across cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("across", "Edm.Boolean", across)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.merge"), _parameters);
    }

    @Action(name = "unmerge")
    @JsonIgnore
    public ActionRequestNoReturn unmerge() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unmerge"), _parameters);
    }

    @Function(name = "boundingRect")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> boundingRect(String anotherRange) {
        Preconditions.checkNotNull(anotherRange, "anotherRange cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("anotherRange", "Edm.String", Checks.checkIsAscii(anotherRange))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.boundingRect"), WorkbookRange.class, _parameters);
    }

    @Function(name = "cell")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> cell(Integer row, Integer column) {
        Preconditions.checkNotNull(row, "row cannot be null");
        Preconditions.checkNotNull(column, "column cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("row", "Edm.Int32", row)
            .put("column", "Edm.Int32", column)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cell"), WorkbookRange.class, _parameters);
    }

    @Function(name = "column")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> column(Integer column) {
        Preconditions.checkNotNull(column, "column cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("column", "Edm.Int32", column)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.column"), WorkbookRange.class, _parameters);
    }

    @Function(name = "columnsAfter")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsAfter() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsAfter"), WorkbookRange.class, _parameters);
    }

    @Function(name = "columnsAfter")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsAfter_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsAfter"), WorkbookRange.class, _parameters);
    }

    @Function(name = "columnsBefore")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsBefore() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsBefore"), WorkbookRange.class, _parameters);
    }

    @Function(name = "columnsBefore")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> columnsBefore_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columnsBefore"), WorkbookRange.class, _parameters);
    }

    @Function(name = "entireColumn")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> entireColumn() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.entireColumn"), WorkbookRange.class, _parameters);
    }

    @Function(name = "entireRow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> entireRow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.entireRow"), WorkbookRange.class, _parameters);
    }

    @Function(name = "intersection")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> intersection(String anotherRange) {
        Preconditions.checkNotNull(anotherRange, "anotherRange cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("anotherRange", "Edm.String", Checks.checkIsAscii(anotherRange))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.intersection"), WorkbookRange.class, _parameters);
    }

    @Function(name = "lastCell")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> lastCell() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lastCell"), WorkbookRange.class, _parameters);
    }

    @Function(name = "lastColumn")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> lastColumn() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lastColumn"), WorkbookRange.class, _parameters);
    }

    @Function(name = "lastRow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> lastRow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lastRow"), WorkbookRange.class, _parameters);
    }

    @Function(name = "offsetRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> offsetRange(Integer rowOffset, Integer columnOffset) {
        Preconditions.checkNotNull(rowOffset, "rowOffset cannot be null");
        Preconditions.checkNotNull(columnOffset, "columnOffset cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rowOffset", "Edm.Int32", rowOffset)
            .put("columnOffset", "Edm.Int32", columnOffset)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.offsetRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "resizedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> resizedRange(Integer deltaRows, Integer deltaColumns) {
        Preconditions.checkNotNull(deltaRows, "deltaRows cannot be null");
        Preconditions.checkNotNull(deltaColumns, "deltaColumns cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deltaRows", "Edm.Int32", deltaRows)
            .put("deltaColumns", "Edm.Int32", deltaColumns)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resizedRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "row")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> row(Integer row) {
        Preconditions.checkNotNull(row, "row cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("row", "Edm.Int32", row)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.row"), WorkbookRange.class, _parameters);
    }

    @Function(name = "rowsAbove")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsAbove() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsAbove"), WorkbookRange.class, _parameters);
    }

    @Function(name = "rowsAbove")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsAbove_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsAbove"), WorkbookRange.class, _parameters);
    }

    @Function(name = "rowsBelow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsBelow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsBelow"), WorkbookRange.class, _parameters);
    }

    @Function(name = "rowsBelow")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> rowsBelow_Function(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rowsBelow"), WorkbookRange.class, _parameters);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "usedRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> usedRange_Function(Boolean valuesOnly) {
        Preconditions.checkNotNull(valuesOnly, "valuesOnly cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("valuesOnly", "Edm.Boolean", valuesOnly)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usedRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "visibleView")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView> visibleView() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.visibleView"), WorkbookRangeView.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookRange[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("addressLocal=");
        b.append(this.addressLocal);
        b.append(", ");
        b.append("cellCount=");
        b.append(this.cellCount);
        b.append(", ");
        b.append("columnCount=");
        b.append(this.columnCount);
        b.append(", ");
        b.append("columnHidden=");
        b.append(this.columnHidden);
        b.append(", ");
        b.append("columnIndex=");
        b.append(this.columnIndex);
        b.append(", ");
        b.append("formulas=");
        b.append(this.formulas);
        b.append(", ");
        b.append("formulasLocal=");
        b.append(this.formulasLocal);
        b.append(", ");
        b.append("formulasR1C1=");
        b.append(this.formulasR1C1);
        b.append(", ");
        b.append("hidden=");
        b.append(this.hidden);
        b.append(", ");
        b.append("numberFormat=");
        b.append(this.numberFormat);
        b.append(", ");
        b.append("rowCount=");
        b.append(this.rowCount);
        b.append(", ");
        b.append("rowHidden=");
        b.append(this.rowHidden);
        b.append(", ");
        b.append("rowIndex=");
        b.append(this.rowIndex);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append(", ");
        b.append("valueTypes=");
        b.append(this.valueTypes);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append(", ");
        b.append("sort=");
        b.append(this.sort);
        b.append(", ");
        b.append("worksheet=");
        b.append(this.worksheet);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
