package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartTitleFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overlay", 
    "text", 
    "visible", 
    "format"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartTitle extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartTitle";
    }

    @JsonProperty("overlay")
    protected Boolean overlay;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("visible")
    protected Boolean visible;

    @JsonProperty("format")
    protected WorkbookChartTitleFormat format;

    protected WorkbookChartTitle() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartTitle() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean overlay;
        private String text;
        private Boolean visible;
        private WorkbookChartTitleFormat format;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder overlay(Boolean overlay) {
            this.overlay = overlay;
            this.changedFields = changedFields.add("overlay");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder visible(Boolean visible) {
            this.visible = visible;
            this.changedFields = changedFields.add("visible");
            return this;
        }

        public Builder format(WorkbookChartTitleFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public WorkbookChartTitle build() {
            WorkbookChartTitle _x = new WorkbookChartTitle();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartTitle";
            _x.id = id;
            _x.overlay = overlay;
            _x.text = text;
            _x.visible = visible;
            _x.format = format;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="overlay")
    @JsonIgnore
    public Optional<Boolean> getOverlay() {
        return Optional.ofNullable(overlay);
    }

    public WorkbookChartTitle withOverlay(Boolean overlay) {
        WorkbookChartTitle _x = _copy();
        _x.changedFields = changedFields.add("overlay");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartTitle");
        _x.overlay = overlay;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public WorkbookChartTitle withText(String text) {
        WorkbookChartTitle _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartTitle");
        _x.text = text;
        return _x;
    }

    @Property(name="visible")
    @JsonIgnore
    public Optional<Boolean> getVisible() {
        return Optional.ofNullable(visible);
    }

    public WorkbookChartTitle withVisible(Boolean visible) {
        WorkbookChartTitle _x = _copy();
        _x.changedFields = changedFields.add("visible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartTitle");
        _x.visible = visible;
        return _x;
    }

    public WorkbookChartTitle withUnmappedField(String name, Object value) {
        WorkbookChartTitle _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartTitleFormatRequest getFormat() {
        return new WorkbookChartTitleFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    public WorkbookChartTitle withFormat(WorkbookChartTitleFormat format) {
        WorkbookChartTitle _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartTitle");
        _x.format = format;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartTitle patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartTitle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartTitle put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartTitle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartTitle _copy() {
        WorkbookChartTitle _x = new WorkbookChartTitle();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.overlay = overlay;
        _x.text = text;
        _x.visible = visible;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartTitle[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("overlay=");
        b.append(this.overlay);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("visible=");
        b.append(this.visible);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
