package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WorkbookChartPointCollectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartSeriesFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "format", 
    "points"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartSeries extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartSeries";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("format")
    protected WorkbookChartSeriesFormat format;

    @JsonProperty("points")
    protected List<WorkbookChartPoint> points;

    protected WorkbookChartSeries() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartSeries() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private WorkbookChartSeriesFormat format;
        private List<WorkbookChartPoint> points;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder format(WorkbookChartSeriesFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public Builder points(List<WorkbookChartPoint> points) {
            this.points = points;
            this.changedFields = changedFields.add("points");
            return this;
        }

        public Builder points(WorkbookChartPoint... points) {
            return points(Arrays.asList(points));
        }

        public WorkbookChartSeries build() {
            WorkbookChartSeries _x = new WorkbookChartSeries();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartSeries";
            _x.id = id;
            _x.name = name;
            _x.format = format;
            _x.points = points;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WorkbookChartSeries withName(String name) {
        WorkbookChartSeries _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartSeries");
        _x.name = name;
        return _x;
    }

    public WorkbookChartSeries withUnmappedField(String name, Object value) {
        WorkbookChartSeries _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartSeriesFormatRequest getFormat() {
        return new WorkbookChartSeriesFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    @NavigationProperty(name="points")
    @JsonIgnore
    public WorkbookChartPointCollectionRequest getPoints() {
        return new WorkbookChartPointCollectionRequest(
                        contextPath.addSegment("points"), Optional.ofNullable(points));
    }

    public WorkbookChartSeries withFormat(WorkbookChartSeriesFormat format) {
        WorkbookChartSeries _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartSeries");
        _x.format = format;
        return _x;
    }

    public WorkbookChartSeries withPoints(List<WorkbookChartPoint> points) {
        WorkbookChartSeries _x = _copy();
        _x.changedFields = changedFields.add("points");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartSeries");
        _x.points = points;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartSeries patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartSeries _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartSeries put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartSeries _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartSeries _copy() {
        WorkbookChartSeries _x = new WorkbookChartSeries();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.format = format;
        _x.points = points;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartSeries[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append(", ");
        b.append("points=");
        b.append(this.points);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
