package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.request.WorkbookChartPointFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "value", 
    "format"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartPoint extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartPoint";
    }

    @JsonProperty("value")
    protected Json value;

    @JsonProperty("format")
    protected WorkbookChartPointFormat format;

    protected WorkbookChartPoint() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartPoint() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Json value;
        private WorkbookChartPointFormat format;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder value(Json value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder format(WorkbookChartPointFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public WorkbookChartPoint build() {
            WorkbookChartPoint _x = new WorkbookChartPoint();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartPoint";
            _x.id = id;
            _x.value = value;
            _x.format = format;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<Json> getValue() {
        return Optional.ofNullable(value);
    }

    public WorkbookChartPoint withValue(Json value) {
        WorkbookChartPoint _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartPoint");
        _x.value = value;
        return _x;
    }

    public WorkbookChartPoint withUnmappedField(String name, Object value) {
        WorkbookChartPoint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartPointFormatRequest getFormat() {
        return new WorkbookChartPointFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    public WorkbookChartPoint withFormat(WorkbookChartPointFormat format) {
        WorkbookChartPoint _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartPoint");
        _x.format = format;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartPoint patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartPoint _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartPoint put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartPoint _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartPoint _copy() {
        WorkbookChartPoint _x = new WorkbookChartPoint();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.value = value;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartPoint[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
