package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartLegendFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overlay", 
    "position", 
    "visible", 
    "format"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartLegend extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartLegend";
    }

    @JsonProperty("overlay")
    protected Boolean overlay;

    @JsonProperty("position")
    protected String position;

    @JsonProperty("visible")
    protected Boolean visible;

    @JsonProperty("format")
    protected WorkbookChartLegendFormat format;

    protected WorkbookChartLegend() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartLegend() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean overlay;
        private String position;
        private Boolean visible;
        private WorkbookChartLegendFormat format;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder overlay(Boolean overlay) {
            this.overlay = overlay;
            this.changedFields = changedFields.add("overlay");
            return this;
        }

        public Builder position(String position) {
            this.position = position;
            this.changedFields = changedFields.add("position");
            return this;
        }

        public Builder visible(Boolean visible) {
            this.visible = visible;
            this.changedFields = changedFields.add("visible");
            return this;
        }

        public Builder format(WorkbookChartLegendFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public WorkbookChartLegend build() {
            WorkbookChartLegend _x = new WorkbookChartLegend();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartLegend";
            _x.id = id;
            _x.overlay = overlay;
            _x.position = position;
            _x.visible = visible;
            _x.format = format;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="overlay")
    @JsonIgnore
    public Optional<Boolean> getOverlay() {
        return Optional.ofNullable(overlay);
    }

    public WorkbookChartLegend withOverlay(Boolean overlay) {
        WorkbookChartLegend _x = _copy();
        _x.changedFields = changedFields.add("overlay");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartLegend");
        _x.overlay = overlay;
        return _x;
    }

    @Property(name="position")
    @JsonIgnore
    public Optional<String> getPosition() {
        return Optional.ofNullable(position);
    }

    public WorkbookChartLegend withPosition(String position) {
        WorkbookChartLegend _x = _copy();
        _x.changedFields = changedFields.add("position");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartLegend");
        _x.position = position;
        return _x;
    }

    @Property(name="visible")
    @JsonIgnore
    public Optional<Boolean> getVisible() {
        return Optional.ofNullable(visible);
    }

    public WorkbookChartLegend withVisible(Boolean visible) {
        WorkbookChartLegend _x = _copy();
        _x.changedFields = changedFields.add("visible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartLegend");
        _x.visible = visible;
        return _x;
    }

    public WorkbookChartLegend withUnmappedField(String name, Object value) {
        WorkbookChartLegend _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartLegendFormatRequest getFormat() {
        return new WorkbookChartLegendFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    public WorkbookChartLegend withFormat(WorkbookChartLegendFormat format) {
        WorkbookChartLegend _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartLegend");
        _x.format = format;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartLegend patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartLegend _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartLegend put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartLegend _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartLegend _copy() {
        WorkbookChartLegend _x = new WorkbookChartLegend();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.overlay = overlay;
        _x.position = position;
        _x.visible = visible;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartLegend[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("overlay=");
        b.append(this.overlay);
        b.append(", ");
        b.append("position=");
        b.append(this.position);
        b.append(", ");
        b.append("visible=");
        b.append(this.visible);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
