package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartGridlinesFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "visible", 
    "format"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartGridlines extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartGridlines";
    }

    @JsonProperty("visible")
    protected Boolean visible;

    @JsonProperty("format")
    protected WorkbookChartGridlinesFormat format;

    protected WorkbookChartGridlines() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartGridlines() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean visible;
        private WorkbookChartGridlinesFormat format;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder visible(Boolean visible) {
            this.visible = visible;
            this.changedFields = changedFields.add("visible");
            return this;
        }

        public Builder format(WorkbookChartGridlinesFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public WorkbookChartGridlines build() {
            WorkbookChartGridlines _x = new WorkbookChartGridlines();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartGridlines";
            _x.id = id;
            _x.visible = visible;
            _x.format = format;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="visible")
    @JsonIgnore
    public Optional<Boolean> getVisible() {
        return Optional.ofNullable(visible);
    }

    public WorkbookChartGridlines withVisible(Boolean visible) {
        WorkbookChartGridlines _x = _copy();
        _x.changedFields = changedFields.add("visible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartGridlines");
        _x.visible = visible;
        return _x;
    }

    public WorkbookChartGridlines withUnmappedField(String name, Object value) {
        WorkbookChartGridlines _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartGridlinesFormatRequest getFormat() {
        return new WorkbookChartGridlinesFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    public WorkbookChartGridlines withFormat(WorkbookChartGridlinesFormat format) {
        WorkbookChartGridlines _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartGridlines");
        _x.format = format;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartGridlines patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartGridlines _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartGridlines put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartGridlines _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartGridlines _copy() {
        WorkbookChartGridlines _x = new WorkbookChartGridlines();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.visible = visible;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartGridlines[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("visible=");
        b.append(this.visible);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
