package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartDataLabelFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "position", 
    "separator", 
    "showBubbleSize", 
    "showCategoryName", 
    "showLegendKey", 
    "showPercentage", 
    "showSeriesName", 
    "showValue", 
    "format"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartDataLabels extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartDataLabels";
    }

    @JsonProperty("position")
    protected String position;

    @JsonProperty("separator")
    protected String separator;

    @JsonProperty("showBubbleSize")
    protected Boolean showBubbleSize;

    @JsonProperty("showCategoryName")
    protected Boolean showCategoryName;

    @JsonProperty("showLegendKey")
    protected Boolean showLegendKey;

    @JsonProperty("showPercentage")
    protected Boolean showPercentage;

    @JsonProperty("showSeriesName")
    protected Boolean showSeriesName;

    @JsonProperty("showValue")
    protected Boolean showValue;

    @JsonProperty("format")
    protected WorkbookChartDataLabelFormat format;

    protected WorkbookChartDataLabels() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartDataLabels() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String position;
        private String separator;
        private Boolean showBubbleSize;
        private Boolean showCategoryName;
        private Boolean showLegendKey;
        private Boolean showPercentage;
        private Boolean showSeriesName;
        private Boolean showValue;
        private WorkbookChartDataLabelFormat format;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder position(String position) {
            this.position = position;
            this.changedFields = changedFields.add("position");
            return this;
        }

        public Builder separator(String separator) {
            this.separator = separator;
            this.changedFields = changedFields.add("separator");
            return this;
        }

        public Builder showBubbleSize(Boolean showBubbleSize) {
            this.showBubbleSize = showBubbleSize;
            this.changedFields = changedFields.add("showBubbleSize");
            return this;
        }

        public Builder showCategoryName(Boolean showCategoryName) {
            this.showCategoryName = showCategoryName;
            this.changedFields = changedFields.add("showCategoryName");
            return this;
        }

        public Builder showLegendKey(Boolean showLegendKey) {
            this.showLegendKey = showLegendKey;
            this.changedFields = changedFields.add("showLegendKey");
            return this;
        }

        public Builder showPercentage(Boolean showPercentage) {
            this.showPercentage = showPercentage;
            this.changedFields = changedFields.add("showPercentage");
            return this;
        }

        public Builder showSeriesName(Boolean showSeriesName) {
            this.showSeriesName = showSeriesName;
            this.changedFields = changedFields.add("showSeriesName");
            return this;
        }

        public Builder showValue(Boolean showValue) {
            this.showValue = showValue;
            this.changedFields = changedFields.add("showValue");
            return this;
        }

        public Builder format(WorkbookChartDataLabelFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public WorkbookChartDataLabels build() {
            WorkbookChartDataLabels _x = new WorkbookChartDataLabels();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartDataLabels";
            _x.id = id;
            _x.position = position;
            _x.separator = separator;
            _x.showBubbleSize = showBubbleSize;
            _x.showCategoryName = showCategoryName;
            _x.showLegendKey = showLegendKey;
            _x.showPercentage = showPercentage;
            _x.showSeriesName = showSeriesName;
            _x.showValue = showValue;
            _x.format = format;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="position")
    @JsonIgnore
    public Optional<String> getPosition() {
        return Optional.ofNullable(position);
    }

    public WorkbookChartDataLabels withPosition(String position) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("position");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.position = position;
        return _x;
    }

    @Property(name="separator")
    @JsonIgnore
    public Optional<String> getSeparator() {
        return Optional.ofNullable(separator);
    }

    public WorkbookChartDataLabels withSeparator(String separator) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("separator");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.separator = separator;
        return _x;
    }

    @Property(name="showBubbleSize")
    @JsonIgnore
    public Optional<Boolean> getShowBubbleSize() {
        return Optional.ofNullable(showBubbleSize);
    }

    public WorkbookChartDataLabels withShowBubbleSize(Boolean showBubbleSize) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("showBubbleSize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.showBubbleSize = showBubbleSize;
        return _x;
    }

    @Property(name="showCategoryName")
    @JsonIgnore
    public Optional<Boolean> getShowCategoryName() {
        return Optional.ofNullable(showCategoryName);
    }

    public WorkbookChartDataLabels withShowCategoryName(Boolean showCategoryName) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("showCategoryName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.showCategoryName = showCategoryName;
        return _x;
    }

    @Property(name="showLegendKey")
    @JsonIgnore
    public Optional<Boolean> getShowLegendKey() {
        return Optional.ofNullable(showLegendKey);
    }

    public WorkbookChartDataLabels withShowLegendKey(Boolean showLegendKey) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("showLegendKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.showLegendKey = showLegendKey;
        return _x;
    }

    @Property(name="showPercentage")
    @JsonIgnore
    public Optional<Boolean> getShowPercentage() {
        return Optional.ofNullable(showPercentage);
    }

    public WorkbookChartDataLabels withShowPercentage(Boolean showPercentage) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("showPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.showPercentage = showPercentage;
        return _x;
    }

    @Property(name="showSeriesName")
    @JsonIgnore
    public Optional<Boolean> getShowSeriesName() {
        return Optional.ofNullable(showSeriesName);
    }

    public WorkbookChartDataLabels withShowSeriesName(Boolean showSeriesName) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("showSeriesName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.showSeriesName = showSeriesName;
        return _x;
    }

    @Property(name="showValue")
    @JsonIgnore
    public Optional<Boolean> getShowValue() {
        return Optional.ofNullable(showValue);
    }

    public WorkbookChartDataLabels withShowValue(Boolean showValue) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("showValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.showValue = showValue;
        return _x;
    }

    public WorkbookChartDataLabels withUnmappedField(String name, Object value) {
        WorkbookChartDataLabels _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartDataLabelFormatRequest getFormat() {
        return new WorkbookChartDataLabelFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    public WorkbookChartDataLabels withFormat(WorkbookChartDataLabelFormat format) {
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartDataLabels");
        _x.format = format;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartDataLabels patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartDataLabels put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartDataLabels _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartDataLabels _copy() {
        WorkbookChartDataLabels _x = new WorkbookChartDataLabels();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.position = position;
        _x.separator = separator;
        _x.showBubbleSize = showBubbleSize;
        _x.showCategoryName = showCategoryName;
        _x.showLegendKey = showLegendKey;
        _x.showPercentage = showPercentage;
        _x.showSeriesName = showSeriesName;
        _x.showValue = showValue;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartDataLabels[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("position=");
        b.append(this.position);
        b.append(", ");
        b.append("separator=");
        b.append(this.separator);
        b.append(", ");
        b.append("showBubbleSize=");
        b.append(this.showBubbleSize);
        b.append(", ");
        b.append("showCategoryName=");
        b.append(this.showCategoryName);
        b.append(", ");
        b.append("showLegendKey=");
        b.append(this.showLegendKey);
        b.append(", ");
        b.append("showPercentage=");
        b.append(this.showPercentage);
        b.append(", ");
        b.append("showSeriesName=");
        b.append(this.showSeriesName);
        b.append(", ");
        b.append("showValue=");
        b.append(this.showValue);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
