package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartFontRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "font"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartAxisTitleFormat extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartAxisTitleFormat";
    }

    @JsonProperty("font")
    protected WorkbookChartFont font;

    protected WorkbookChartAxisTitleFormat() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartAxisTitleFormat() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WorkbookChartFont font;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder font(WorkbookChartFont font) {
            this.font = font;
            this.changedFields = changedFields.add("font");
            return this;
        }

        public WorkbookChartAxisTitleFormat build() {
            WorkbookChartAxisTitleFormat _x = new WorkbookChartAxisTitleFormat();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartAxisTitleFormat";
            _x.id = id;
            _x.font = font;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public WorkbookChartAxisTitleFormat withUnmappedField(String name, Object value) {
        WorkbookChartAxisTitleFormat _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="font")
    @JsonIgnore
    public WorkbookChartFontRequest getFont() {
        return new WorkbookChartFontRequest(contextPath.addSegment("font"), Optional.ofNullable(font));
    }

    public WorkbookChartAxisTitleFormat withFont(WorkbookChartFont font) {
        WorkbookChartAxisTitleFormat _x = _copy();
        _x.changedFields = changedFields.add("font");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxisTitleFormat");
        _x.font = font;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxisTitleFormat patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxisTitleFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxisTitleFormat put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxisTitleFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartAxisTitleFormat _copy() {
        WorkbookChartAxisTitleFormat _x = new WorkbookChartAxisTitleFormat();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.font = font;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartAxisTitleFormat[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("font=");
        b.append(this.font);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
