package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.WindowsUpdateInstallScheduleType;
import odata.msgraph.client.beta.entity.collection.request.WindowsUpdateStateCollectionRequest;
import odata.msgraph.client.beta.enums.AutoRestartNotificationDismissalMethod;
import odata.msgraph.client.beta.enums.AutomaticUpdateMode;
import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.PrereleaseFeatures;
import odata.msgraph.client.beta.enums.WindowsDeliveryOptimizationMode;
import odata.msgraph.client.beta.enums.WindowsUpdateForBusinessUpdateWeeks;
import odata.msgraph.client.beta.enums.WindowsUpdateNotificationDisplayOption;
import odata.msgraph.client.beta.enums.WindowsUpdateType;


/**
 * <i>“Windows Update for business configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowWindows11Upgrade", 
    "automaticUpdateMode", 
    "autoRestartNotificationDismissal", 
    "businessReadyUpdatesOnly", 
    "deadlineForFeatureUpdatesInDays", 
    "deadlineForQualityUpdatesInDays", 
    "deadlineGracePeriodInDays", 
    "deliveryOptimizationMode", 
    "driversExcluded", 
    "engagedRestartDeadlineInDays", 
    "engagedRestartSnoozeScheduleInDays", 
    "engagedRestartTransitionScheduleInDays", 
    "featureUpdatesDeferralPeriodInDays", 
    "featureUpdatesPaused", 
    "featureUpdatesPauseExpiryDateTime", 
    "featureUpdatesPauseStartDate", 
    "featureUpdatesRollbackStartDateTime", 
    "featureUpdatesRollbackWindowInDays", 
    "featureUpdatesWillBeRolledBack", 
    "installationSchedule", 
    "microsoftUpdateServiceAllowed", 
    "postponeRebootUntilAfterDeadline", 
    "prereleaseFeatures", 
    "qualityUpdatesDeferralPeriodInDays", 
    "qualityUpdatesPaused", 
    "qualityUpdatesPauseExpiryDateTime", 
    "qualityUpdatesPauseStartDate", 
    "qualityUpdatesRollbackStartDateTime", 
    "qualityUpdatesWillBeRolledBack", 
    "scheduleImminentRestartWarningInMinutes", 
    "scheduleRestartWarningInHours", 
    "skipChecksBeforeRestart", 
    "updateNotificationLevel", 
    "updateWeeks", 
    "userPauseAccess", 
    "userWindowsUpdateScanAccess", 
    "deviceUpdateStates"})
@JsonInclude(Include.NON_NULL)
public class WindowsUpdateForBusinessConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdateForBusinessConfiguration";
    }

    @JsonProperty("allowWindows11Upgrade")
    protected Boolean allowWindows11Upgrade;

    @JsonProperty("automaticUpdateMode")
    protected AutomaticUpdateMode automaticUpdateMode;

    @JsonProperty("autoRestartNotificationDismissal")
    protected AutoRestartNotificationDismissalMethod autoRestartNotificationDismissal;

    @JsonProperty("businessReadyUpdatesOnly")
    protected WindowsUpdateType businessReadyUpdatesOnly;

    @JsonProperty("deadlineForFeatureUpdatesInDays")
    protected Integer deadlineForFeatureUpdatesInDays;

    @JsonProperty("deadlineForQualityUpdatesInDays")
    protected Integer deadlineForQualityUpdatesInDays;

    @JsonProperty("deadlineGracePeriodInDays")
    protected Integer deadlineGracePeriodInDays;

    @JsonProperty("deliveryOptimizationMode")
    protected WindowsDeliveryOptimizationMode deliveryOptimizationMode;

    @JsonProperty("driversExcluded")
    protected Boolean driversExcluded;

    @JsonProperty("engagedRestartDeadlineInDays")
    protected Integer engagedRestartDeadlineInDays;

    @JsonProperty("engagedRestartSnoozeScheduleInDays")
    protected Integer engagedRestartSnoozeScheduleInDays;

    @JsonProperty("engagedRestartTransitionScheduleInDays")
    protected Integer engagedRestartTransitionScheduleInDays;

    @JsonProperty("featureUpdatesDeferralPeriodInDays")
    protected Integer featureUpdatesDeferralPeriodInDays;

    @JsonProperty("featureUpdatesPaused")
    protected Boolean featureUpdatesPaused;

    @JsonProperty("featureUpdatesPauseExpiryDateTime")
    protected OffsetDateTime featureUpdatesPauseExpiryDateTime;

    @JsonProperty("featureUpdatesPauseStartDate")
    protected LocalDate featureUpdatesPauseStartDate;

    @JsonProperty("featureUpdatesRollbackStartDateTime")
    protected OffsetDateTime featureUpdatesRollbackStartDateTime;

    @JsonProperty("featureUpdatesRollbackWindowInDays")
    protected Integer featureUpdatesRollbackWindowInDays;

    @JsonProperty("featureUpdatesWillBeRolledBack")
    protected Boolean featureUpdatesWillBeRolledBack;

    @JsonProperty("installationSchedule")
    protected WindowsUpdateInstallScheduleType installationSchedule;

    @JsonProperty("microsoftUpdateServiceAllowed")
    protected Boolean microsoftUpdateServiceAllowed;

    @JsonProperty("postponeRebootUntilAfterDeadline")
    protected Boolean postponeRebootUntilAfterDeadline;

    @JsonProperty("prereleaseFeatures")
    protected PrereleaseFeatures prereleaseFeatures;

    @JsonProperty("qualityUpdatesDeferralPeriodInDays")
    protected Integer qualityUpdatesDeferralPeriodInDays;

    @JsonProperty("qualityUpdatesPaused")
    protected Boolean qualityUpdatesPaused;

    @JsonProperty("qualityUpdatesPauseExpiryDateTime")
    protected OffsetDateTime qualityUpdatesPauseExpiryDateTime;

    @JsonProperty("qualityUpdatesPauseStartDate")
    protected LocalDate qualityUpdatesPauseStartDate;

    @JsonProperty("qualityUpdatesRollbackStartDateTime")
    protected OffsetDateTime qualityUpdatesRollbackStartDateTime;

    @JsonProperty("qualityUpdatesWillBeRolledBack")
    protected Boolean qualityUpdatesWillBeRolledBack;

    @JsonProperty("scheduleImminentRestartWarningInMinutes")
    protected Integer scheduleImminentRestartWarningInMinutes;

    @JsonProperty("scheduleRestartWarningInHours")
    protected Integer scheduleRestartWarningInHours;

    @JsonProperty("skipChecksBeforeRestart")
    protected Boolean skipChecksBeforeRestart;

    @JsonProperty("updateNotificationLevel")
    protected WindowsUpdateNotificationDisplayOption updateNotificationLevel;

    @JsonProperty("updateWeeks")
    protected WindowsUpdateForBusinessUpdateWeeks updateWeeks;

    @JsonProperty("userPauseAccess")
    protected Enablement userPauseAccess;

    @JsonProperty("userWindowsUpdateScanAccess")
    protected Enablement userWindowsUpdateScanAccess;

    @JsonProperty("deviceUpdateStates")
    protected List<WindowsUpdateState> deviceUpdateStates;

    protected WindowsUpdateForBusinessConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsUpdateForBusinessConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean allowWindows11Upgrade;
        private AutomaticUpdateMode automaticUpdateMode;
        private AutoRestartNotificationDismissalMethod autoRestartNotificationDismissal;
        private WindowsUpdateType businessReadyUpdatesOnly;
        private Integer deadlineForFeatureUpdatesInDays;
        private Integer deadlineForQualityUpdatesInDays;
        private Integer deadlineGracePeriodInDays;
        private WindowsDeliveryOptimizationMode deliveryOptimizationMode;
        private Boolean driversExcluded;
        private Integer engagedRestartDeadlineInDays;
        private Integer engagedRestartSnoozeScheduleInDays;
        private Integer engagedRestartTransitionScheduleInDays;
        private Integer featureUpdatesDeferralPeriodInDays;
        private Boolean featureUpdatesPaused;
        private OffsetDateTime featureUpdatesPauseExpiryDateTime;
        private LocalDate featureUpdatesPauseStartDate;
        private OffsetDateTime featureUpdatesRollbackStartDateTime;
        private Integer featureUpdatesRollbackWindowInDays;
        private Boolean featureUpdatesWillBeRolledBack;
        private WindowsUpdateInstallScheduleType installationSchedule;
        private Boolean microsoftUpdateServiceAllowed;
        private Boolean postponeRebootUntilAfterDeadline;
        private PrereleaseFeatures prereleaseFeatures;
        private Integer qualityUpdatesDeferralPeriodInDays;
        private Boolean qualityUpdatesPaused;
        private OffsetDateTime qualityUpdatesPauseExpiryDateTime;
        private LocalDate qualityUpdatesPauseStartDate;
        private OffsetDateTime qualityUpdatesRollbackStartDateTime;
        private Boolean qualityUpdatesWillBeRolledBack;
        private Integer scheduleImminentRestartWarningInMinutes;
        private Integer scheduleRestartWarningInHours;
        private Boolean skipChecksBeforeRestart;
        private WindowsUpdateNotificationDisplayOption updateNotificationLevel;
        private WindowsUpdateForBusinessUpdateWeeks updateWeeks;
        private Enablement userPauseAccess;
        private Enablement userWindowsUpdateScanAccess;
        private List<WindowsUpdateState> deviceUpdateStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Allow eligible Windows 10 devices to upgrade to the latest version of Windows 11
         * .”</i>
         * 
         * @param allowWindows11Upgrade
         *            value of {@code allowWindows11Upgrade} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowWindows11Upgrade(Boolean allowWindows11Upgrade) {
            this.allowWindows11Upgrade = allowWindows11Upgrade;
            this.changedFields = changedFields.add("allowWindows11Upgrade");
            return this;
        }

        /**
         * <i>“Automatic update mode.”</i>
         * 
         * @param automaticUpdateMode
         *            value of {@code automaticUpdateMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder automaticUpdateMode(AutomaticUpdateMode automaticUpdateMode) {
            this.automaticUpdateMode = automaticUpdateMode;
            this.changedFields = changedFields.add("automaticUpdateMode");
            return this;
        }

        /**
         * <i>“Specify the method by which the auto-restart required notification is dismissed”</i>
         * 
         * @param autoRestartNotificationDismissal
         *            value of {@code autoRestartNotificationDismissal} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoRestartNotificationDismissal(AutoRestartNotificationDismissalMethod autoRestartNotificationDismissal) {
            this.autoRestartNotificationDismissal = autoRestartNotificationDismissal;
            this.changedFields = changedFields.add("autoRestartNotificationDismissal");
            return this;
        }

        /**
         * <i>“Determines which branch devices will receive their updates from”</i>
         * 
         * @param businessReadyUpdatesOnly
         *            value of {@code businessReadyUpdatesOnly} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder businessReadyUpdatesOnly(WindowsUpdateType businessReadyUpdatesOnly) {
            this.businessReadyUpdatesOnly = businessReadyUpdatesOnly;
            this.changedFields = changedFields.add("businessReadyUpdatesOnly");
            return this;
        }

        /**
         * <i>“Number of days before feature updates are installed automatically with valid
         * range from 2 to 30 days”</i>
         * 
         * @param deadlineForFeatureUpdatesInDays
         *            value of {@code deadlineForFeatureUpdatesInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deadlineForFeatureUpdatesInDays(Integer deadlineForFeatureUpdatesInDays) {
            this.deadlineForFeatureUpdatesInDays = deadlineForFeatureUpdatesInDays;
            this.changedFields = changedFields.add("deadlineForFeatureUpdatesInDays");
            return this;
        }

        /**
         * <i>“Number of days before quality updates are installed automatically with valid
         * range from 2 to 30 days”</i>
         * 
         * @param deadlineForQualityUpdatesInDays
         *            value of {@code deadlineForQualityUpdatesInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deadlineForQualityUpdatesInDays(Integer deadlineForQualityUpdatesInDays) {
            this.deadlineForQualityUpdatesInDays = deadlineForQualityUpdatesInDays;
            this.changedFields = changedFields.add("deadlineForQualityUpdatesInDays");
            return this;
        }

        /**
         * <i>“Number of days after deadline  until restarts occur automatically with valid
         * range from 0 to 7 days”</i>
         * 
         * @param deadlineGracePeriodInDays
         *            value of {@code deadlineGracePeriodInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deadlineGracePeriodInDays(Integer deadlineGracePeriodInDays) {
            this.deadlineGracePeriodInDays = deadlineGracePeriodInDays;
            this.changedFields = changedFields.add("deadlineGracePeriodInDays");
            return this;
        }

        /**
         * <i>“Delivery Optimization Mode”</i>
         * 
         * @param deliveryOptimizationMode
         *            value of {@code deliveryOptimizationMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deliveryOptimizationMode(WindowsDeliveryOptimizationMode deliveryOptimizationMode) {
            this.deliveryOptimizationMode = deliveryOptimizationMode;
            this.changedFields = changedFields.add("deliveryOptimizationMode");
            return this;
        }

        /**
         * <i>“Exclude Windows update Drivers”</i>
         * 
         * @param driversExcluded
         *            value of {@code driversExcluded} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder driversExcluded(Boolean driversExcluded) {
            this.driversExcluded = driversExcluded;
            this.changedFields = changedFields.add("driversExcluded");
            return this;
        }

        /**
         * <i>“Deadline in days before automatically scheduling and executing a pending restart
         * outside of active hours, with valid range from 2 to 30 days”</i>
         * 
         * @param engagedRestartDeadlineInDays
         *            value of {@code engagedRestartDeadlineInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder engagedRestartDeadlineInDays(Integer engagedRestartDeadlineInDays) {
            this.engagedRestartDeadlineInDays = engagedRestartDeadlineInDays;
            this.changedFields = changedFields.add("engagedRestartDeadlineInDays");
            return this;
        }

        /**
         * <i>“Number of days a user can snooze Engaged Restart reminder notifications with
         * valid range from 1 to 3 days”</i>
         * 
         * @param engagedRestartSnoozeScheduleInDays
         *            value of {@code engagedRestartSnoozeScheduleInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder engagedRestartSnoozeScheduleInDays(Integer engagedRestartSnoozeScheduleInDays) {
            this.engagedRestartSnoozeScheduleInDays = engagedRestartSnoozeScheduleInDays;
            this.changedFields = changedFields.add("engagedRestartSnoozeScheduleInDays");
            return this;
        }

        /**
         * <i>“Number of days before transitioning from Auto Restarts scheduled outside of
         * active hours to Engaged Restart, which requires the user to schedule, with valid
         * range from 0 to 30 days”</i>
         * 
         * @param engagedRestartTransitionScheduleInDays
         *            value of {@code engagedRestartTransitionScheduleInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder engagedRestartTransitionScheduleInDays(Integer engagedRestartTransitionScheduleInDays) {
            this.engagedRestartTransitionScheduleInDays = engagedRestartTransitionScheduleInDays;
            this.changedFields = changedFields.add("engagedRestartTransitionScheduleInDays");
            return this;
        }

        /**
         * <i>“Defer Feature Updates by these many days”</i>
         * 
         * @param featureUpdatesDeferralPeriodInDays
         *            value of {@code featureUpdatesDeferralPeriodInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdatesDeferralPeriodInDays(Integer featureUpdatesDeferralPeriodInDays) {
            this.featureUpdatesDeferralPeriodInDays = featureUpdatesDeferralPeriodInDays;
            this.changedFields = changedFields.add("featureUpdatesDeferralPeriodInDays");
            return this;
        }

        /**
         * <i>“Pause Feature Updates”</i>
         * 
         * @param featureUpdatesPaused
         *            value of {@code featureUpdatesPaused} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdatesPaused(Boolean featureUpdatesPaused) {
            this.featureUpdatesPaused = featureUpdatesPaused;
            this.changedFields = changedFields.add("featureUpdatesPaused");
            return this;
        }

        /**
         * <i>“Feature Updates Pause Expiry datetime”</i>
         * 
         * @param featureUpdatesPauseExpiryDateTime
         *            value of {@code featureUpdatesPauseExpiryDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdatesPauseExpiryDateTime(OffsetDateTime featureUpdatesPauseExpiryDateTime) {
            this.featureUpdatesPauseExpiryDateTime = featureUpdatesPauseExpiryDateTime;
            this.changedFields = changedFields.add("featureUpdatesPauseExpiryDateTime");
            return this;
        }

        /**
         * <i>“Feature Updates Pause start date. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param featureUpdatesPauseStartDate
         *            value of {@code featureUpdatesPauseStartDate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdatesPauseStartDate(LocalDate featureUpdatesPauseStartDate) {
            this.featureUpdatesPauseStartDate = featureUpdatesPauseStartDate;
            this.changedFields = changedFields.add("featureUpdatesPauseStartDate");
            return this;
        }

        /**
         * <i>“Feature Updates Rollback Start datetime”</i>
         * 
         * @param featureUpdatesRollbackStartDateTime
         *            value of {@code featureUpdatesRollbackStartDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdatesRollbackStartDateTime(OffsetDateTime featureUpdatesRollbackStartDateTime) {
            this.featureUpdatesRollbackStartDateTime = featureUpdatesRollbackStartDateTime;
            this.changedFields = changedFields.add("featureUpdatesRollbackStartDateTime");
            return this;
        }

        /**
         * <i>“The number of days after a Feature Update for which a rollback is valid”</i>
         * 
         * @param featureUpdatesRollbackWindowInDays
         *            value of {@code featureUpdatesRollbackWindowInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdatesRollbackWindowInDays(Integer featureUpdatesRollbackWindowInDays) {
            this.featureUpdatesRollbackWindowInDays = featureUpdatesRollbackWindowInDays;
            this.changedFields = changedFields.add("featureUpdatesRollbackWindowInDays");
            return this;
        }

        /**
         * <i>“Specifies whether to rollback Feature Updates on the next device check in”</i>
         * 
         * @param featureUpdatesWillBeRolledBack
         *            value of {@code featureUpdatesWillBeRolledBack} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdatesWillBeRolledBack(Boolean featureUpdatesWillBeRolledBack) {
            this.featureUpdatesWillBeRolledBack = featureUpdatesWillBeRolledBack;
            this.changedFields = changedFields.add("featureUpdatesWillBeRolledBack");
            return this;
        }

        /**
         * <i>“Installation schedule”</i>
         * 
         * @param installationSchedule
         *            value of {@code installationSchedule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installationSchedule(WindowsUpdateInstallScheduleType installationSchedule) {
            this.installationSchedule = installationSchedule;
            this.changedFields = changedFields.add("installationSchedule");
            return this;
        }

        /**
         * <i>“Allow Microsoft Update Service”</i>
         * 
         * @param microsoftUpdateServiceAllowed
         *            value of {@code microsoftUpdateServiceAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftUpdateServiceAllowed(Boolean microsoftUpdateServiceAllowed) {
            this.microsoftUpdateServiceAllowed = microsoftUpdateServiceAllowed;
            this.changedFields = changedFields.add("microsoftUpdateServiceAllowed");
            return this;
        }

        /**
         * <i>“Specifies if the device should wait until deadline for rebooting outside of
         * active hours”</i>
         * 
         * @param postponeRebootUntilAfterDeadline
         *            value of {@code postponeRebootUntilAfterDeadline} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder postponeRebootUntilAfterDeadline(Boolean postponeRebootUntilAfterDeadline) {
            this.postponeRebootUntilAfterDeadline = postponeRebootUntilAfterDeadline;
            this.changedFields = changedFields.add("postponeRebootUntilAfterDeadline");
            return this;
        }

        /**
         * <i>“The pre-release features.”</i>
         * 
         * @param prereleaseFeatures
         *            value of {@code prereleaseFeatures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder prereleaseFeatures(PrereleaseFeatures prereleaseFeatures) {
            this.prereleaseFeatures = prereleaseFeatures;
            this.changedFields = changedFields.add("prereleaseFeatures");
            return this;
        }

        /**
         * <i>“Defer Quality Updates by these many days”</i>
         * 
         * @param qualityUpdatesDeferralPeriodInDays
         *            value of {@code qualityUpdatesDeferralPeriodInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdatesDeferralPeriodInDays(Integer qualityUpdatesDeferralPeriodInDays) {
            this.qualityUpdatesDeferralPeriodInDays = qualityUpdatesDeferralPeriodInDays;
            this.changedFields = changedFields.add("qualityUpdatesDeferralPeriodInDays");
            return this;
        }

        /**
         * <i>“Pause Quality Updates”</i>
         * 
         * @param qualityUpdatesPaused
         *            value of {@code qualityUpdatesPaused} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdatesPaused(Boolean qualityUpdatesPaused) {
            this.qualityUpdatesPaused = qualityUpdatesPaused;
            this.changedFields = changedFields.add("qualityUpdatesPaused");
            return this;
        }

        /**
         * <i>“Quality Updates Pause Expiry datetime”</i>
         * 
         * @param qualityUpdatesPauseExpiryDateTime
         *            value of {@code qualityUpdatesPauseExpiryDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdatesPauseExpiryDateTime(OffsetDateTime qualityUpdatesPauseExpiryDateTime) {
            this.qualityUpdatesPauseExpiryDateTime = qualityUpdatesPauseExpiryDateTime;
            this.changedFields = changedFields.add("qualityUpdatesPauseExpiryDateTime");
            return this;
        }

        /**
         * <i>“Quality Updates Pause start date. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param qualityUpdatesPauseStartDate
         *            value of {@code qualityUpdatesPauseStartDate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdatesPauseStartDate(LocalDate qualityUpdatesPauseStartDate) {
            this.qualityUpdatesPauseStartDate = qualityUpdatesPauseStartDate;
            this.changedFields = changedFields.add("qualityUpdatesPauseStartDate");
            return this;
        }

        /**
         * <i>“Quality Updates Rollback Start datetime”</i>
         * 
         * @param qualityUpdatesRollbackStartDateTime
         *            value of {@code qualityUpdatesRollbackStartDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdatesRollbackStartDateTime(OffsetDateTime qualityUpdatesRollbackStartDateTime) {
            this.qualityUpdatesRollbackStartDateTime = qualityUpdatesRollbackStartDateTime;
            this.changedFields = changedFields.add("qualityUpdatesRollbackStartDateTime");
            return this;
        }

        /**
         * <i>“Specifies whether to rollback Quality Updates on the next device check in”</i>
         * 
         * @param qualityUpdatesWillBeRolledBack
         *            value of {@code qualityUpdatesWillBeRolledBack} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdatesWillBeRolledBack(Boolean qualityUpdatesWillBeRolledBack) {
            this.qualityUpdatesWillBeRolledBack = qualityUpdatesWillBeRolledBack;
            this.changedFields = changedFields.add("qualityUpdatesWillBeRolledBack");
            return this;
        }

        /**
         * <i>“Specify the period for auto-restart imminent warning notifications. Supported
         * values: 15, 30 or 60 (minutes).”</i>
         * 
         * @param scheduleImminentRestartWarningInMinutes
         *            value of {@code scheduleImminentRestartWarningInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduleImminentRestartWarningInMinutes(Integer scheduleImminentRestartWarningInMinutes) {
            this.scheduleImminentRestartWarningInMinutes = scheduleImminentRestartWarningInMinutes;
            this.changedFields = changedFields.add("scheduleImminentRestartWarningInMinutes");
            return this;
        }

        /**
         * <i>“Specify the period for auto-restart warning reminder notifications. Supported
         * values: 2, 4, 8, 12 or 24 (hours).”</i>
         * 
         * @param scheduleRestartWarningInHours
         *            value of {@code scheduleRestartWarningInHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduleRestartWarningInHours(Integer scheduleRestartWarningInHours) {
            this.scheduleRestartWarningInHours = scheduleRestartWarningInHours;
            this.changedFields = changedFields.add("scheduleRestartWarningInHours");
            return this;
        }

        /**
         * <i>“Set to skip all check before restart: Battery level = 40%, User presence,
         * Display Needed, Presentation mode, Full screen mode, phone call state, game mode
         * etc.”</i>
         * 
         * @param skipChecksBeforeRestart
         *            value of {@code skipChecksBeforeRestart} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder skipChecksBeforeRestart(Boolean skipChecksBeforeRestart) {
            this.skipChecksBeforeRestart = skipChecksBeforeRestart;
            this.changedFields = changedFields.add("skipChecksBeforeRestart");
            return this;
        }

        /**
         * <i>“Specifies what Windows Update notifications users see.”</i>
         * 
         * @param updateNotificationLevel
         *            value of {@code updateNotificationLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateNotificationLevel(WindowsUpdateNotificationDisplayOption updateNotificationLevel) {
            this.updateNotificationLevel = updateNotificationLevel;
            this.changedFields = changedFields.add("updateNotificationLevel");
            return this;
        }

        /**
         * <i>“Scheduled the update installation on the weeks of the month”</i>
         * 
         * @param updateWeeks
         *            value of {@code updateWeeks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateWeeks(WindowsUpdateForBusinessUpdateWeeks updateWeeks) {
            this.updateWeeks = updateWeeks;
            this.changedFields = changedFields.add("updateWeeks");
            return this;
        }

        /**
         * <i>“Specifies whether to enable end user’s access to pause software updates.”</i>
         * 
         * @param userPauseAccess
         *            value of {@code userPauseAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPauseAccess(Enablement userPauseAccess) {
            this.userPauseAccess = userPauseAccess;
            this.changedFields = changedFields.add("userPauseAccess");
            return this;
        }

        /**
         * <i>“Specifies whether to disable user’s access to scan Windows Update.”</i>
         * 
         * @param userWindowsUpdateScanAccess
         *            value of {@code userWindowsUpdateScanAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userWindowsUpdateScanAccess(Enablement userWindowsUpdateScanAccess) {
            this.userWindowsUpdateScanAccess = userWindowsUpdateScanAccess;
            this.changedFields = changedFields.add("userWindowsUpdateScanAccess");
            return this;
        }

        /**
         * <i>“Windows update for business configuration device states. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param deviceUpdateStates
         *            value of {@code deviceUpdateStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceUpdateStates(List<WindowsUpdateState> deviceUpdateStates) {
            this.deviceUpdateStates = deviceUpdateStates;
            this.changedFields = changedFields.add("deviceUpdateStates");
            return this;
        }

        /**
         * <i>“Windows update for business configuration device states. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param deviceUpdateStates
         *            value of {@code deviceUpdateStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceUpdateStates(WindowsUpdateState... deviceUpdateStates) {
            return deviceUpdateStates(Arrays.asList(deviceUpdateStates));
        }

        public WindowsUpdateForBusinessConfiguration build() {
            WindowsUpdateForBusinessConfiguration _x = new WindowsUpdateForBusinessConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdateForBusinessConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.allowWindows11Upgrade = allowWindows11Upgrade;
            _x.automaticUpdateMode = automaticUpdateMode;
            _x.autoRestartNotificationDismissal = autoRestartNotificationDismissal;
            _x.businessReadyUpdatesOnly = businessReadyUpdatesOnly;
            _x.deadlineForFeatureUpdatesInDays = deadlineForFeatureUpdatesInDays;
            _x.deadlineForQualityUpdatesInDays = deadlineForQualityUpdatesInDays;
            _x.deadlineGracePeriodInDays = deadlineGracePeriodInDays;
            _x.deliveryOptimizationMode = deliveryOptimizationMode;
            _x.driversExcluded = driversExcluded;
            _x.engagedRestartDeadlineInDays = engagedRestartDeadlineInDays;
            _x.engagedRestartSnoozeScheduleInDays = engagedRestartSnoozeScheduleInDays;
            _x.engagedRestartTransitionScheduleInDays = engagedRestartTransitionScheduleInDays;
            _x.featureUpdatesDeferralPeriodInDays = featureUpdatesDeferralPeriodInDays;
            _x.featureUpdatesPaused = featureUpdatesPaused;
            _x.featureUpdatesPauseExpiryDateTime = featureUpdatesPauseExpiryDateTime;
            _x.featureUpdatesPauseStartDate = featureUpdatesPauseStartDate;
            _x.featureUpdatesRollbackStartDateTime = featureUpdatesRollbackStartDateTime;
            _x.featureUpdatesRollbackWindowInDays = featureUpdatesRollbackWindowInDays;
            _x.featureUpdatesWillBeRolledBack = featureUpdatesWillBeRolledBack;
            _x.installationSchedule = installationSchedule;
            _x.microsoftUpdateServiceAllowed = microsoftUpdateServiceAllowed;
            _x.postponeRebootUntilAfterDeadline = postponeRebootUntilAfterDeadline;
            _x.prereleaseFeatures = prereleaseFeatures;
            _x.qualityUpdatesDeferralPeriodInDays = qualityUpdatesDeferralPeriodInDays;
            _x.qualityUpdatesPaused = qualityUpdatesPaused;
            _x.qualityUpdatesPauseExpiryDateTime = qualityUpdatesPauseExpiryDateTime;
            _x.qualityUpdatesPauseStartDate = qualityUpdatesPauseStartDate;
            _x.qualityUpdatesRollbackStartDateTime = qualityUpdatesRollbackStartDateTime;
            _x.qualityUpdatesWillBeRolledBack = qualityUpdatesWillBeRolledBack;
            _x.scheduleImminentRestartWarningInMinutes = scheduleImminentRestartWarningInMinutes;
            _x.scheduleRestartWarningInHours = scheduleRestartWarningInHours;
            _x.skipChecksBeforeRestart = skipChecksBeforeRestart;
            _x.updateNotificationLevel = updateNotificationLevel;
            _x.updateWeeks = updateWeeks;
            _x.userPauseAccess = userPauseAccess;
            _x.userWindowsUpdateScanAccess = userWindowsUpdateScanAccess;
            _x.deviceUpdateStates = deviceUpdateStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Allow eligible Windows 10 devices to upgrade to the latest version of Windows 11
     * .”</i>
     * 
     * @return property allowWindows11Upgrade
     */
    @Property(name="allowWindows11Upgrade")
    @JsonIgnore
    public Optional<Boolean> getAllowWindows11Upgrade() {
        return Optional.ofNullable(allowWindows11Upgrade);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowWindows11Upgrade} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allow eligible Windows 10 devices to upgrade to the latest version of Windows 11
     * .”</i>
     * 
     * @param allowWindows11Upgrade
     *            new value of {@code allowWindows11Upgrade} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowWindows11Upgrade} field changed
     */
    public WindowsUpdateForBusinessConfiguration withAllowWindows11Upgrade(Boolean allowWindows11Upgrade) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowWindows11Upgrade");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.allowWindows11Upgrade = allowWindows11Upgrade;
        return _x;
    }

    /**
     * <i>“Automatic update mode.”</i>
     * 
     * @return property automaticUpdateMode
     */
    @Property(name="automaticUpdateMode")
    @JsonIgnore
    public Optional<AutomaticUpdateMode> getAutomaticUpdateMode() {
        return Optional.ofNullable(automaticUpdateMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * automaticUpdateMode} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Automatic update mode.”</i>
     * 
     * @param automaticUpdateMode
     *            new value of {@code automaticUpdateMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code automaticUpdateMode} field changed
     */
    public WindowsUpdateForBusinessConfiguration withAutomaticUpdateMode(AutomaticUpdateMode automaticUpdateMode) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("automaticUpdateMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.automaticUpdateMode = automaticUpdateMode;
        return _x;
    }

    /**
     * <i>“Specify the method by which the auto-restart required notification is dismissed”</i>
     * 
     * @return property autoRestartNotificationDismissal
     */
    @Property(name="autoRestartNotificationDismissal")
    @JsonIgnore
    public Optional<AutoRestartNotificationDismissalMethod> getAutoRestartNotificationDismissal() {
        return Optional.ofNullable(autoRestartNotificationDismissal);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * autoRestartNotificationDismissal} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify the method by which the auto-restart required notification is dismissed”</i>
     * 
     * @param autoRestartNotificationDismissal
     *            new value of {@code autoRestartNotificationDismissal} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoRestartNotificationDismissal} field changed
     */
    public WindowsUpdateForBusinessConfiguration withAutoRestartNotificationDismissal(AutoRestartNotificationDismissalMethod autoRestartNotificationDismissal) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("autoRestartNotificationDismissal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.autoRestartNotificationDismissal = autoRestartNotificationDismissal;
        return _x;
    }

    /**
     * <i>“Determines which branch devices will receive their updates from”</i>
     * 
     * @return property businessReadyUpdatesOnly
     */
    @Property(name="businessReadyUpdatesOnly")
    @JsonIgnore
    public Optional<WindowsUpdateType> getBusinessReadyUpdatesOnly() {
        return Optional.ofNullable(businessReadyUpdatesOnly);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * businessReadyUpdatesOnly} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determines which branch devices will receive their updates from”</i>
     * 
     * @param businessReadyUpdatesOnly
     *            new value of {@code businessReadyUpdatesOnly} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code businessReadyUpdatesOnly} field changed
     */
    public WindowsUpdateForBusinessConfiguration withBusinessReadyUpdatesOnly(WindowsUpdateType businessReadyUpdatesOnly) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("businessReadyUpdatesOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.businessReadyUpdatesOnly = businessReadyUpdatesOnly;
        return _x;
    }

    /**
     * <i>“Number of days before feature updates are installed automatically with valid
     * range from 2 to 30 days”</i>
     * 
     * @return property deadlineForFeatureUpdatesInDays
     */
    @Property(name="deadlineForFeatureUpdatesInDays")
    @JsonIgnore
    public Optional<Integer> getDeadlineForFeatureUpdatesInDays() {
        return Optional.ofNullable(deadlineForFeatureUpdatesInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deadlineForFeatureUpdatesInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of days before feature updates are installed automatically with valid
     * range from 2 to 30 days”</i>
     * 
     * @param deadlineForFeatureUpdatesInDays
     *            new value of {@code deadlineForFeatureUpdatesInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deadlineForFeatureUpdatesInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withDeadlineForFeatureUpdatesInDays(Integer deadlineForFeatureUpdatesInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deadlineForFeatureUpdatesInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.deadlineForFeatureUpdatesInDays = deadlineForFeatureUpdatesInDays;
        return _x;
    }

    /**
     * <i>“Number of days before quality updates are installed automatically with valid
     * range from 2 to 30 days”</i>
     * 
     * @return property deadlineForQualityUpdatesInDays
     */
    @Property(name="deadlineForQualityUpdatesInDays")
    @JsonIgnore
    public Optional<Integer> getDeadlineForQualityUpdatesInDays() {
        return Optional.ofNullable(deadlineForQualityUpdatesInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deadlineForQualityUpdatesInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of days before quality updates are installed automatically with valid
     * range from 2 to 30 days”</i>
     * 
     * @param deadlineForQualityUpdatesInDays
     *            new value of {@code deadlineForQualityUpdatesInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deadlineForQualityUpdatesInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withDeadlineForQualityUpdatesInDays(Integer deadlineForQualityUpdatesInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deadlineForQualityUpdatesInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.deadlineForQualityUpdatesInDays = deadlineForQualityUpdatesInDays;
        return _x;
    }

    /**
     * <i>“Number of days after deadline  until restarts occur automatically with valid
     * range from 0 to 7 days”</i>
     * 
     * @return property deadlineGracePeriodInDays
     */
    @Property(name="deadlineGracePeriodInDays")
    @JsonIgnore
    public Optional<Integer> getDeadlineGracePeriodInDays() {
        return Optional.ofNullable(deadlineGracePeriodInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deadlineGracePeriodInDays} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days after deadline  until restarts occur automatically with valid
     * range from 0 to 7 days”</i>
     * 
     * @param deadlineGracePeriodInDays
     *            new value of {@code deadlineGracePeriodInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deadlineGracePeriodInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withDeadlineGracePeriodInDays(Integer deadlineGracePeriodInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deadlineGracePeriodInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.deadlineGracePeriodInDays = deadlineGracePeriodInDays;
        return _x;
    }

    /**
     * <i>“Delivery Optimization Mode”</i>
     * 
     * @return property deliveryOptimizationMode
     */
    @Property(name="deliveryOptimizationMode")
    @JsonIgnore
    public Optional<WindowsDeliveryOptimizationMode> getDeliveryOptimizationMode() {
        return Optional.ofNullable(deliveryOptimizationMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deliveryOptimizationMode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Delivery Optimization Mode”</i>
     * 
     * @param deliveryOptimizationMode
     *            new value of {@code deliveryOptimizationMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deliveryOptimizationMode} field changed
     */
    public WindowsUpdateForBusinessConfiguration withDeliveryOptimizationMode(WindowsDeliveryOptimizationMode deliveryOptimizationMode) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deliveryOptimizationMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.deliveryOptimizationMode = deliveryOptimizationMode;
        return _x;
    }

    /**
     * <i>“Exclude Windows update Drivers”</i>
     * 
     * @return property driversExcluded
     */
    @Property(name="driversExcluded")
    @JsonIgnore
    public Optional<Boolean> getDriversExcluded() {
        return Optional.ofNullable(driversExcluded);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code driversExcluded}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Exclude Windows update Drivers”</i>
     * 
     * @param driversExcluded
     *            new value of {@code driversExcluded} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code driversExcluded} field changed
     */
    public WindowsUpdateForBusinessConfiguration withDriversExcluded(Boolean driversExcluded) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("driversExcluded");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.driversExcluded = driversExcluded;
        return _x;
    }

    /**
     * <i>“Deadline in days before automatically scheduling and executing a pending restart
     * outside of active hours, with valid range from 2 to 30 days”</i>
     * 
     * @return property engagedRestartDeadlineInDays
     */
    @Property(name="engagedRestartDeadlineInDays")
    @JsonIgnore
    public Optional<Integer> getEngagedRestartDeadlineInDays() {
        return Optional.ofNullable(engagedRestartDeadlineInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * engagedRestartDeadlineInDays} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Deadline in days before automatically scheduling and executing a pending restart
     * outside of active hours, with valid range from 2 to 30 days”</i>
     * 
     * @param engagedRestartDeadlineInDays
     *            new value of {@code engagedRestartDeadlineInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code engagedRestartDeadlineInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withEngagedRestartDeadlineInDays(Integer engagedRestartDeadlineInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("engagedRestartDeadlineInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.engagedRestartDeadlineInDays = engagedRestartDeadlineInDays;
        return _x;
    }

    /**
     * <i>“Number of days a user can snooze Engaged Restart reminder notifications with
     * valid range from 1 to 3 days”</i>
     * 
     * @return property engagedRestartSnoozeScheduleInDays
     */
    @Property(name="engagedRestartSnoozeScheduleInDays")
    @JsonIgnore
    public Optional<Integer> getEngagedRestartSnoozeScheduleInDays() {
        return Optional.ofNullable(engagedRestartSnoozeScheduleInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * engagedRestartSnoozeScheduleInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of days a user can snooze Engaged Restart reminder notifications with
     * valid range from 1 to 3 days”</i>
     * 
     * @param engagedRestartSnoozeScheduleInDays
     *            new value of {@code engagedRestartSnoozeScheduleInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code engagedRestartSnoozeScheduleInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withEngagedRestartSnoozeScheduleInDays(Integer engagedRestartSnoozeScheduleInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("engagedRestartSnoozeScheduleInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.engagedRestartSnoozeScheduleInDays = engagedRestartSnoozeScheduleInDays;
        return _x;
    }

    /**
     * <i>“Number of days before transitioning from Auto Restarts scheduled outside of
     * active hours to Engaged Restart, which requires the user to schedule, with valid
     * range from 0 to 30 days”</i>
     * 
     * @return property engagedRestartTransitionScheduleInDays
     */
    @Property(name="engagedRestartTransitionScheduleInDays")
    @JsonIgnore
    public Optional<Integer> getEngagedRestartTransitionScheduleInDays() {
        return Optional.ofNullable(engagedRestartTransitionScheduleInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * engagedRestartTransitionScheduleInDays} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of days before transitioning from Auto Restarts scheduled outside of
     * active hours to Engaged Restart, which requires the user to schedule, with valid
     * range from 0 to 30 days”</i>
     * 
     * @param engagedRestartTransitionScheduleInDays
     *            new value of {@code engagedRestartTransitionScheduleInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code engagedRestartTransitionScheduleInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withEngagedRestartTransitionScheduleInDays(Integer engagedRestartTransitionScheduleInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("engagedRestartTransitionScheduleInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.engagedRestartTransitionScheduleInDays = engagedRestartTransitionScheduleInDays;
        return _x;
    }

    /**
     * <i>“Defer Feature Updates by these many days”</i>
     * 
     * @return property featureUpdatesDeferralPeriodInDays
     */
    @Property(name="featureUpdatesDeferralPeriodInDays")
    @JsonIgnore
    public Optional<Integer> getFeatureUpdatesDeferralPeriodInDays() {
        return Optional.ofNullable(featureUpdatesDeferralPeriodInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdatesDeferralPeriodInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Defer Feature Updates by these many days”</i>
     * 
     * @param featureUpdatesDeferralPeriodInDays
     *            new value of {@code featureUpdatesDeferralPeriodInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdatesDeferralPeriodInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withFeatureUpdatesDeferralPeriodInDays(Integer featureUpdatesDeferralPeriodInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("featureUpdatesDeferralPeriodInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.featureUpdatesDeferralPeriodInDays = featureUpdatesDeferralPeriodInDays;
        return _x;
    }

    /**
     * <i>“Pause Feature Updates”</i>
     * 
     * @return property featureUpdatesPaused
     */
    @Property(name="featureUpdatesPaused")
    @JsonIgnore
    public Optional<Boolean> getFeatureUpdatesPaused() {
        return Optional.ofNullable(featureUpdatesPaused);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdatesPaused} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Pause Feature Updates”</i>
     * 
     * @param featureUpdatesPaused
     *            new value of {@code featureUpdatesPaused} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdatesPaused} field changed
     */
    public WindowsUpdateForBusinessConfiguration withFeatureUpdatesPaused(Boolean featureUpdatesPaused) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("featureUpdatesPaused");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.featureUpdatesPaused = featureUpdatesPaused;
        return _x;
    }

    /**
     * <i>“Feature Updates Pause Expiry datetime”</i>
     * 
     * @return property featureUpdatesPauseExpiryDateTime
     */
    @Property(name="featureUpdatesPauseExpiryDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFeatureUpdatesPauseExpiryDateTime() {
        return Optional.ofNullable(featureUpdatesPauseExpiryDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdatesPauseExpiryDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Feature Updates Pause Expiry datetime”</i>
     * 
     * @param featureUpdatesPauseExpiryDateTime
     *            new value of {@code featureUpdatesPauseExpiryDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdatesPauseExpiryDateTime} field changed
     */
    public WindowsUpdateForBusinessConfiguration withFeatureUpdatesPauseExpiryDateTime(OffsetDateTime featureUpdatesPauseExpiryDateTime) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("featureUpdatesPauseExpiryDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.featureUpdatesPauseExpiryDateTime = featureUpdatesPauseExpiryDateTime;
        return _x;
    }

    /**
     * <i>“Feature Updates Pause start date. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property featureUpdatesPauseStartDate
     */
    @Property(name="featureUpdatesPauseStartDate")
    @JsonIgnore
    public Optional<LocalDate> getFeatureUpdatesPauseStartDate() {
        return Optional.ofNullable(featureUpdatesPauseStartDate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdatesPauseStartDate} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Feature Updates Pause start date. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param featureUpdatesPauseStartDate
     *            new value of {@code featureUpdatesPauseStartDate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdatesPauseStartDate} field changed
     */
    public WindowsUpdateForBusinessConfiguration withFeatureUpdatesPauseStartDate(LocalDate featureUpdatesPauseStartDate) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("featureUpdatesPauseStartDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.featureUpdatesPauseStartDate = featureUpdatesPauseStartDate;
        return _x;
    }

    /**
     * <i>“Feature Updates Rollback Start datetime”</i>
     * 
     * @return property featureUpdatesRollbackStartDateTime
     */
    @Property(name="featureUpdatesRollbackStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFeatureUpdatesRollbackStartDateTime() {
        return Optional.ofNullable(featureUpdatesRollbackStartDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdatesRollbackStartDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Feature Updates Rollback Start datetime”</i>
     * 
     * @param featureUpdatesRollbackStartDateTime
     *            new value of {@code featureUpdatesRollbackStartDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdatesRollbackStartDateTime} field changed
     */
    public WindowsUpdateForBusinessConfiguration withFeatureUpdatesRollbackStartDateTime(OffsetDateTime featureUpdatesRollbackStartDateTime) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("featureUpdatesRollbackStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.featureUpdatesRollbackStartDateTime = featureUpdatesRollbackStartDateTime;
        return _x;
    }

    /**
     * <i>“The number of days after a Feature Update for which a rollback is valid”</i>
     * 
     * @return property featureUpdatesRollbackWindowInDays
     */
    @Property(name="featureUpdatesRollbackWindowInDays")
    @JsonIgnore
    public Optional<Integer> getFeatureUpdatesRollbackWindowInDays() {
        return Optional.ofNullable(featureUpdatesRollbackWindowInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdatesRollbackWindowInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of days after a Feature Update for which a rollback is valid”</i>
     * 
     * @param featureUpdatesRollbackWindowInDays
     *            new value of {@code featureUpdatesRollbackWindowInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdatesRollbackWindowInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withFeatureUpdatesRollbackWindowInDays(Integer featureUpdatesRollbackWindowInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("featureUpdatesRollbackWindowInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.featureUpdatesRollbackWindowInDays = featureUpdatesRollbackWindowInDays;
        return _x;
    }

    /**
     * <i>“Specifies whether to rollback Feature Updates on the next device check in”</i>
     * 
     * @return property featureUpdatesWillBeRolledBack
     */
    @Property(name="featureUpdatesWillBeRolledBack")
    @JsonIgnore
    public Optional<Boolean> getFeatureUpdatesWillBeRolledBack() {
        return Optional.ofNullable(featureUpdatesWillBeRolledBack);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdatesWillBeRolledBack} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specifies whether to rollback Feature Updates on the next device check in”</i>
     * 
     * @param featureUpdatesWillBeRolledBack
     *            new value of {@code featureUpdatesWillBeRolledBack} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdatesWillBeRolledBack} field changed
     */
    public WindowsUpdateForBusinessConfiguration withFeatureUpdatesWillBeRolledBack(Boolean featureUpdatesWillBeRolledBack) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("featureUpdatesWillBeRolledBack");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.featureUpdatesWillBeRolledBack = featureUpdatesWillBeRolledBack;
        return _x;
    }

    /**
     * <i>“Installation schedule”</i>
     * 
     * @return property installationSchedule
     */
    @Property(name="installationSchedule")
    @JsonIgnore
    public Optional<WindowsUpdateInstallScheduleType> getInstallationSchedule() {
        return Optional.ofNullable(installationSchedule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installationSchedule} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Installation schedule”</i>
     * 
     * @param installationSchedule
     *            new value of {@code installationSchedule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installationSchedule} field changed
     */
    public WindowsUpdateForBusinessConfiguration withInstallationSchedule(WindowsUpdateInstallScheduleType installationSchedule) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("installationSchedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.installationSchedule = installationSchedule;
        return _x;
    }

    /**
     * <i>“Allow Microsoft Update Service”</i>
     * 
     * @return property microsoftUpdateServiceAllowed
     */
    @Property(name="microsoftUpdateServiceAllowed")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftUpdateServiceAllowed() {
        return Optional.ofNullable(microsoftUpdateServiceAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftUpdateServiceAllowed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow Microsoft Update Service”</i>
     * 
     * @param microsoftUpdateServiceAllowed
     *            new value of {@code microsoftUpdateServiceAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftUpdateServiceAllowed} field changed
     */
    public WindowsUpdateForBusinessConfiguration withMicrosoftUpdateServiceAllowed(Boolean microsoftUpdateServiceAllowed) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftUpdateServiceAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.microsoftUpdateServiceAllowed = microsoftUpdateServiceAllowed;
        return _x;
    }

    /**
     * <i>“Specifies if the device should wait until deadline for rebooting outside of
     * active hours”</i>
     * 
     * @return property postponeRebootUntilAfterDeadline
     */
    @Property(name="postponeRebootUntilAfterDeadline")
    @JsonIgnore
    public Optional<Boolean> getPostponeRebootUntilAfterDeadline() {
        return Optional.ofNullable(postponeRebootUntilAfterDeadline);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * postponeRebootUntilAfterDeadline} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specifies if the device should wait until deadline for rebooting outside of
     * active hours”</i>
     * 
     * @param postponeRebootUntilAfterDeadline
     *            new value of {@code postponeRebootUntilAfterDeadline} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code postponeRebootUntilAfterDeadline} field changed
     */
    public WindowsUpdateForBusinessConfiguration withPostponeRebootUntilAfterDeadline(Boolean postponeRebootUntilAfterDeadline) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("postponeRebootUntilAfterDeadline");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.postponeRebootUntilAfterDeadline = postponeRebootUntilAfterDeadline;
        return _x;
    }

    /**
     * <i>“The pre-release features.”</i>
     * 
     * @return property prereleaseFeatures
     */
    @Property(name="prereleaseFeatures")
    @JsonIgnore
    public Optional<PrereleaseFeatures> getPrereleaseFeatures() {
        return Optional.ofNullable(prereleaseFeatures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * prereleaseFeatures} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The pre-release features.”</i>
     * 
     * @param prereleaseFeatures
     *            new value of {@code prereleaseFeatures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code prereleaseFeatures} field changed
     */
    public WindowsUpdateForBusinessConfiguration withPrereleaseFeatures(PrereleaseFeatures prereleaseFeatures) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("prereleaseFeatures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.prereleaseFeatures = prereleaseFeatures;
        return _x;
    }

    /**
     * <i>“Defer Quality Updates by these many days”</i>
     * 
     * @return property qualityUpdatesDeferralPeriodInDays
     */
    @Property(name="qualityUpdatesDeferralPeriodInDays")
    @JsonIgnore
    public Optional<Integer> getQualityUpdatesDeferralPeriodInDays() {
        return Optional.ofNullable(qualityUpdatesDeferralPeriodInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdatesDeferralPeriodInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Defer Quality Updates by these many days”</i>
     * 
     * @param qualityUpdatesDeferralPeriodInDays
     *            new value of {@code qualityUpdatesDeferralPeriodInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdatesDeferralPeriodInDays} field changed
     */
    public WindowsUpdateForBusinessConfiguration withQualityUpdatesDeferralPeriodInDays(Integer qualityUpdatesDeferralPeriodInDays) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdatesDeferralPeriodInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.qualityUpdatesDeferralPeriodInDays = qualityUpdatesDeferralPeriodInDays;
        return _x;
    }

    /**
     * <i>“Pause Quality Updates”</i>
     * 
     * @return property qualityUpdatesPaused
     */
    @Property(name="qualityUpdatesPaused")
    @JsonIgnore
    public Optional<Boolean> getQualityUpdatesPaused() {
        return Optional.ofNullable(qualityUpdatesPaused);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdatesPaused} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Pause Quality Updates”</i>
     * 
     * @param qualityUpdatesPaused
     *            new value of {@code qualityUpdatesPaused} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdatesPaused} field changed
     */
    public WindowsUpdateForBusinessConfiguration withQualityUpdatesPaused(Boolean qualityUpdatesPaused) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdatesPaused");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.qualityUpdatesPaused = qualityUpdatesPaused;
        return _x;
    }

    /**
     * <i>“Quality Updates Pause Expiry datetime”</i>
     * 
     * @return property qualityUpdatesPauseExpiryDateTime
     */
    @Property(name="qualityUpdatesPauseExpiryDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getQualityUpdatesPauseExpiryDateTime() {
        return Optional.ofNullable(qualityUpdatesPauseExpiryDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdatesPauseExpiryDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Quality Updates Pause Expiry datetime”</i>
     * 
     * @param qualityUpdatesPauseExpiryDateTime
     *            new value of {@code qualityUpdatesPauseExpiryDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdatesPauseExpiryDateTime} field changed
     */
    public WindowsUpdateForBusinessConfiguration withQualityUpdatesPauseExpiryDateTime(OffsetDateTime qualityUpdatesPauseExpiryDateTime) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdatesPauseExpiryDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.qualityUpdatesPauseExpiryDateTime = qualityUpdatesPauseExpiryDateTime;
        return _x;
    }

    /**
     * <i>“Quality Updates Pause start date. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property qualityUpdatesPauseStartDate
     */
    @Property(name="qualityUpdatesPauseStartDate")
    @JsonIgnore
    public Optional<LocalDate> getQualityUpdatesPauseStartDate() {
        return Optional.ofNullable(qualityUpdatesPauseStartDate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdatesPauseStartDate} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Quality Updates Pause start date. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param qualityUpdatesPauseStartDate
     *            new value of {@code qualityUpdatesPauseStartDate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdatesPauseStartDate} field changed
     */
    public WindowsUpdateForBusinessConfiguration withQualityUpdatesPauseStartDate(LocalDate qualityUpdatesPauseStartDate) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdatesPauseStartDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.qualityUpdatesPauseStartDate = qualityUpdatesPauseStartDate;
        return _x;
    }

    /**
     * <i>“Quality Updates Rollback Start datetime”</i>
     * 
     * @return property qualityUpdatesRollbackStartDateTime
     */
    @Property(name="qualityUpdatesRollbackStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getQualityUpdatesRollbackStartDateTime() {
        return Optional.ofNullable(qualityUpdatesRollbackStartDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdatesRollbackStartDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Quality Updates Rollback Start datetime”</i>
     * 
     * @param qualityUpdatesRollbackStartDateTime
     *            new value of {@code qualityUpdatesRollbackStartDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdatesRollbackStartDateTime} field changed
     */
    public WindowsUpdateForBusinessConfiguration withQualityUpdatesRollbackStartDateTime(OffsetDateTime qualityUpdatesRollbackStartDateTime) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdatesRollbackStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.qualityUpdatesRollbackStartDateTime = qualityUpdatesRollbackStartDateTime;
        return _x;
    }

    /**
     * <i>“Specifies whether to rollback Quality Updates on the next device check in”</i>
     * 
     * @return property qualityUpdatesWillBeRolledBack
     */
    @Property(name="qualityUpdatesWillBeRolledBack")
    @JsonIgnore
    public Optional<Boolean> getQualityUpdatesWillBeRolledBack() {
        return Optional.ofNullable(qualityUpdatesWillBeRolledBack);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdatesWillBeRolledBack} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specifies whether to rollback Quality Updates on the next device check in”</i>
     * 
     * @param qualityUpdatesWillBeRolledBack
     *            new value of {@code qualityUpdatesWillBeRolledBack} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdatesWillBeRolledBack} field changed
     */
    public WindowsUpdateForBusinessConfiguration withQualityUpdatesWillBeRolledBack(Boolean qualityUpdatesWillBeRolledBack) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdatesWillBeRolledBack");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.qualityUpdatesWillBeRolledBack = qualityUpdatesWillBeRolledBack;
        return _x;
    }

    /**
     * <i>“Specify the period for auto-restart imminent warning notifications. Supported
     * values: 15, 30 or 60 (minutes).”</i>
     * 
     * @return property scheduleImminentRestartWarningInMinutes
     */
    @Property(name="scheduleImminentRestartWarningInMinutes")
    @JsonIgnore
    public Optional<Integer> getScheduleImminentRestartWarningInMinutes() {
        return Optional.ofNullable(scheduleImminentRestartWarningInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * scheduleImminentRestartWarningInMinutes} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify the period for auto-restart imminent warning notifications. Supported
     * values: 15, 30 or 60 (minutes).”</i>
     * 
     * @param scheduleImminentRestartWarningInMinutes
     *            new value of {@code scheduleImminentRestartWarningInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scheduleImminentRestartWarningInMinutes} field changed
     */
    public WindowsUpdateForBusinessConfiguration withScheduleImminentRestartWarningInMinutes(Integer scheduleImminentRestartWarningInMinutes) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("scheduleImminentRestartWarningInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.scheduleImminentRestartWarningInMinutes = scheduleImminentRestartWarningInMinutes;
        return _x;
    }

    /**
     * <i>“Specify the period for auto-restart warning reminder notifications. Supported
     * values: 2, 4, 8, 12 or 24 (hours).”</i>
     * 
     * @return property scheduleRestartWarningInHours
     */
    @Property(name="scheduleRestartWarningInHours")
    @JsonIgnore
    public Optional<Integer> getScheduleRestartWarningInHours() {
        return Optional.ofNullable(scheduleRestartWarningInHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * scheduleRestartWarningInHours} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify the period for auto-restart warning reminder notifications. Supported
     * values: 2, 4, 8, 12 or 24 (hours).”</i>
     * 
     * @param scheduleRestartWarningInHours
     *            new value of {@code scheduleRestartWarningInHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scheduleRestartWarningInHours} field changed
     */
    public WindowsUpdateForBusinessConfiguration withScheduleRestartWarningInHours(Integer scheduleRestartWarningInHours) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("scheduleRestartWarningInHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.scheduleRestartWarningInHours = scheduleRestartWarningInHours;
        return _x;
    }

    /**
     * <i>“Set to skip all check before restart: Battery level = 40%, User presence,
     * Display Needed, Presentation mode, Full screen mode, phone call state, game mode
     * etc.”</i>
     * 
     * @return property skipChecksBeforeRestart
     */
    @Property(name="skipChecksBeforeRestart")
    @JsonIgnore
    public Optional<Boolean> getSkipChecksBeforeRestart() {
        return Optional.ofNullable(skipChecksBeforeRestart);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * skipChecksBeforeRestart} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Set to skip all check before restart: Battery level = 40%, User presence,
     * Display Needed, Presentation mode, Full screen mode, phone call state, game mode
     * etc.”</i>
     * 
     * @param skipChecksBeforeRestart
     *            new value of {@code skipChecksBeforeRestart} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code skipChecksBeforeRestart} field changed
     */
    public WindowsUpdateForBusinessConfiguration withSkipChecksBeforeRestart(Boolean skipChecksBeforeRestart) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("skipChecksBeforeRestart");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.skipChecksBeforeRestart = skipChecksBeforeRestart;
        return _x;
    }

    /**
     * <i>“Specifies what Windows Update notifications users see.”</i>
     * 
     * @return property updateNotificationLevel
     */
    @Property(name="updateNotificationLevel")
    @JsonIgnore
    public Optional<WindowsUpdateNotificationDisplayOption> getUpdateNotificationLevel() {
        return Optional.ofNullable(updateNotificationLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * updateNotificationLevel} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies what Windows Update notifications users see.”</i>
     * 
     * @param updateNotificationLevel
     *            new value of {@code updateNotificationLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateNotificationLevel} field changed
     */
    public WindowsUpdateForBusinessConfiguration withUpdateNotificationLevel(WindowsUpdateNotificationDisplayOption updateNotificationLevel) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("updateNotificationLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.updateNotificationLevel = updateNotificationLevel;
        return _x;
    }

    /**
     * <i>“Scheduled the update installation on the weeks of the month”</i>
     * 
     * @return property updateWeeks
     */
    @Property(name="updateWeeks")
    @JsonIgnore
    public Optional<WindowsUpdateForBusinessUpdateWeeks> getUpdateWeeks() {
        return Optional.ofNullable(updateWeeks);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateWeeks}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Scheduled the update installation on the weeks of the month”</i>
     * 
     * @param updateWeeks
     *            new value of {@code updateWeeks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateWeeks} field changed
     */
    public WindowsUpdateForBusinessConfiguration withUpdateWeeks(WindowsUpdateForBusinessUpdateWeeks updateWeeks) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("updateWeeks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.updateWeeks = updateWeeks;
        return _x;
    }

    /**
     * <i>“Specifies whether to enable end user’s access to pause software updates.”</i>
     * 
     * @return property userPauseAccess
     */
    @Property(name="userPauseAccess")
    @JsonIgnore
    public Optional<Enablement> getUserPauseAccess() {
        return Optional.ofNullable(userPauseAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPauseAccess}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies whether to enable end user’s access to pause software updates.”</i>
     * 
     * @param userPauseAccess
     *            new value of {@code userPauseAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPauseAccess} field changed
     */
    public WindowsUpdateForBusinessConfiguration withUserPauseAccess(Enablement userPauseAccess) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userPauseAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.userPauseAccess = userPauseAccess;
        return _x;
    }

    /**
     * <i>“Specifies whether to disable user’s access to scan Windows Update.”</i>
     * 
     * @return property userWindowsUpdateScanAccess
     */
    @Property(name="userWindowsUpdateScanAccess")
    @JsonIgnore
    public Optional<Enablement> getUserWindowsUpdateScanAccess() {
        return Optional.ofNullable(userWindowsUpdateScanAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userWindowsUpdateScanAccess} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies whether to disable user’s access to scan Windows Update.”</i>
     * 
     * @param userWindowsUpdateScanAccess
     *            new value of {@code userWindowsUpdateScanAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userWindowsUpdateScanAccess} field changed
     */
    public WindowsUpdateForBusinessConfiguration withUserWindowsUpdateScanAccess(Enablement userWindowsUpdateScanAccess) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userWindowsUpdateScanAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.userWindowsUpdateScanAccess = userWindowsUpdateScanAccess;
        return _x;
    }

    public WindowsUpdateForBusinessConfiguration withUnmappedField(String name, Object value) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Windows update for business configuration device states. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return navigational property deviceUpdateStates
     */
    @NavigationProperty(name="deviceUpdateStates")
    @JsonIgnore
    public WindowsUpdateStateCollectionRequest getDeviceUpdateStates() {
        return new WindowsUpdateStateCollectionRequest(
                        contextPath.addSegment("deviceUpdateStates"), Optional.ofNullable(deviceUpdateStates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceUpdateStates} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Windows update for business configuration device states. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param deviceUpdateStates
     *            new value of {@code deviceUpdateStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceUpdateStates} field changed
     */
    public WindowsUpdateForBusinessConfiguration withDeviceUpdateStates(List<WindowsUpdateState> deviceUpdateStates) {
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceUpdateStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateForBusinessConfiguration");
        _x.deviceUpdateStates = deviceUpdateStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUpdateForBusinessConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUpdateForBusinessConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsUpdateForBusinessConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsUpdateForBusinessConfiguration _copy() {
        WindowsUpdateForBusinessConfiguration _x = new WindowsUpdateForBusinessConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.allowWindows11Upgrade = allowWindows11Upgrade;
        _x.automaticUpdateMode = automaticUpdateMode;
        _x.autoRestartNotificationDismissal = autoRestartNotificationDismissal;
        _x.businessReadyUpdatesOnly = businessReadyUpdatesOnly;
        _x.deadlineForFeatureUpdatesInDays = deadlineForFeatureUpdatesInDays;
        _x.deadlineForQualityUpdatesInDays = deadlineForQualityUpdatesInDays;
        _x.deadlineGracePeriodInDays = deadlineGracePeriodInDays;
        _x.deliveryOptimizationMode = deliveryOptimizationMode;
        _x.driversExcluded = driversExcluded;
        _x.engagedRestartDeadlineInDays = engagedRestartDeadlineInDays;
        _x.engagedRestartSnoozeScheduleInDays = engagedRestartSnoozeScheduleInDays;
        _x.engagedRestartTransitionScheduleInDays = engagedRestartTransitionScheduleInDays;
        _x.featureUpdatesDeferralPeriodInDays = featureUpdatesDeferralPeriodInDays;
        _x.featureUpdatesPaused = featureUpdatesPaused;
        _x.featureUpdatesPauseExpiryDateTime = featureUpdatesPauseExpiryDateTime;
        _x.featureUpdatesPauseStartDate = featureUpdatesPauseStartDate;
        _x.featureUpdatesRollbackStartDateTime = featureUpdatesRollbackStartDateTime;
        _x.featureUpdatesRollbackWindowInDays = featureUpdatesRollbackWindowInDays;
        _x.featureUpdatesWillBeRolledBack = featureUpdatesWillBeRolledBack;
        _x.installationSchedule = installationSchedule;
        _x.microsoftUpdateServiceAllowed = microsoftUpdateServiceAllowed;
        _x.postponeRebootUntilAfterDeadline = postponeRebootUntilAfterDeadline;
        _x.prereleaseFeatures = prereleaseFeatures;
        _x.qualityUpdatesDeferralPeriodInDays = qualityUpdatesDeferralPeriodInDays;
        _x.qualityUpdatesPaused = qualityUpdatesPaused;
        _x.qualityUpdatesPauseExpiryDateTime = qualityUpdatesPauseExpiryDateTime;
        _x.qualityUpdatesPauseStartDate = qualityUpdatesPauseStartDate;
        _x.qualityUpdatesRollbackStartDateTime = qualityUpdatesRollbackStartDateTime;
        _x.qualityUpdatesWillBeRolledBack = qualityUpdatesWillBeRolledBack;
        _x.scheduleImminentRestartWarningInMinutes = scheduleImminentRestartWarningInMinutes;
        _x.scheduleRestartWarningInHours = scheduleRestartWarningInHours;
        _x.skipChecksBeforeRestart = skipChecksBeforeRestart;
        _x.updateNotificationLevel = updateNotificationLevel;
        _x.updateWeeks = updateWeeks;
        _x.userPauseAccess = userPauseAccess;
        _x.userWindowsUpdateScanAccess = userWindowsUpdateScanAccess;
        _x.deviceUpdateStates = deviceUpdateStates;
        return _x;
    }

    @Action(name = "extendFeatureUpdatesPause")
    @JsonIgnore
    public ActionRequestNoReturn extendFeatureUpdatesPause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.extendFeatureUpdatesPause"), _parameters);
    }

    @Action(name = "extendQualityUpdatesPause")
    @JsonIgnore
    public ActionRequestNoReturn extendQualityUpdatesPause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.extendQualityUpdatesPause"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUpdateForBusinessConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("allowWindows11Upgrade=");
        b.append(this.allowWindows11Upgrade);
        b.append(", ");
        b.append("automaticUpdateMode=");
        b.append(this.automaticUpdateMode);
        b.append(", ");
        b.append("autoRestartNotificationDismissal=");
        b.append(this.autoRestartNotificationDismissal);
        b.append(", ");
        b.append("businessReadyUpdatesOnly=");
        b.append(this.businessReadyUpdatesOnly);
        b.append(", ");
        b.append("deadlineForFeatureUpdatesInDays=");
        b.append(this.deadlineForFeatureUpdatesInDays);
        b.append(", ");
        b.append("deadlineForQualityUpdatesInDays=");
        b.append(this.deadlineForQualityUpdatesInDays);
        b.append(", ");
        b.append("deadlineGracePeriodInDays=");
        b.append(this.deadlineGracePeriodInDays);
        b.append(", ");
        b.append("deliveryOptimizationMode=");
        b.append(this.deliveryOptimizationMode);
        b.append(", ");
        b.append("driversExcluded=");
        b.append(this.driversExcluded);
        b.append(", ");
        b.append("engagedRestartDeadlineInDays=");
        b.append(this.engagedRestartDeadlineInDays);
        b.append(", ");
        b.append("engagedRestartSnoozeScheduleInDays=");
        b.append(this.engagedRestartSnoozeScheduleInDays);
        b.append(", ");
        b.append("engagedRestartTransitionScheduleInDays=");
        b.append(this.engagedRestartTransitionScheduleInDays);
        b.append(", ");
        b.append("featureUpdatesDeferralPeriodInDays=");
        b.append(this.featureUpdatesDeferralPeriodInDays);
        b.append(", ");
        b.append("featureUpdatesPaused=");
        b.append(this.featureUpdatesPaused);
        b.append(", ");
        b.append("featureUpdatesPauseExpiryDateTime=");
        b.append(this.featureUpdatesPauseExpiryDateTime);
        b.append(", ");
        b.append("featureUpdatesPauseStartDate=");
        b.append(this.featureUpdatesPauseStartDate);
        b.append(", ");
        b.append("featureUpdatesRollbackStartDateTime=");
        b.append(this.featureUpdatesRollbackStartDateTime);
        b.append(", ");
        b.append("featureUpdatesRollbackWindowInDays=");
        b.append(this.featureUpdatesRollbackWindowInDays);
        b.append(", ");
        b.append("featureUpdatesWillBeRolledBack=");
        b.append(this.featureUpdatesWillBeRolledBack);
        b.append(", ");
        b.append("installationSchedule=");
        b.append(this.installationSchedule);
        b.append(", ");
        b.append("microsoftUpdateServiceAllowed=");
        b.append(this.microsoftUpdateServiceAllowed);
        b.append(", ");
        b.append("postponeRebootUntilAfterDeadline=");
        b.append(this.postponeRebootUntilAfterDeadline);
        b.append(", ");
        b.append("prereleaseFeatures=");
        b.append(this.prereleaseFeatures);
        b.append(", ");
        b.append("qualityUpdatesDeferralPeriodInDays=");
        b.append(this.qualityUpdatesDeferralPeriodInDays);
        b.append(", ");
        b.append("qualityUpdatesPaused=");
        b.append(this.qualityUpdatesPaused);
        b.append(", ");
        b.append("qualityUpdatesPauseExpiryDateTime=");
        b.append(this.qualityUpdatesPauseExpiryDateTime);
        b.append(", ");
        b.append("qualityUpdatesPauseStartDate=");
        b.append(this.qualityUpdatesPauseStartDate);
        b.append(", ");
        b.append("qualityUpdatesRollbackStartDateTime=");
        b.append(this.qualityUpdatesRollbackStartDateTime);
        b.append(", ");
        b.append("qualityUpdatesWillBeRolledBack=");
        b.append(this.qualityUpdatesWillBeRolledBack);
        b.append(", ");
        b.append("scheduleImminentRestartWarningInMinutes=");
        b.append(this.scheduleImminentRestartWarningInMinutes);
        b.append(", ");
        b.append("scheduleRestartWarningInHours=");
        b.append(this.scheduleRestartWarningInHours);
        b.append(", ");
        b.append("skipChecksBeforeRestart=");
        b.append(this.skipChecksBeforeRestart);
        b.append(", ");
        b.append("updateNotificationLevel=");
        b.append(this.updateNotificationLevel);
        b.append(", ");
        b.append("updateWeeks=");
        b.append(this.updateWeeks);
        b.append(", ");
        b.append("userPauseAccess=");
        b.append(this.userPauseAccess);
        b.append(", ");
        b.append("userWindowsUpdateScanAccess=");
        b.append(this.userWindowsUpdateScanAccess);
        b.append(", ");
        b.append("deviceUpdateStates=");
        b.append(this.deviceUpdateStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
