package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Windows update catalog item entity”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "endOfSupportDate", 
    "releaseDateTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsUpdateCatalogItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdateCatalogItem";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endOfSupportDate")
    protected OffsetDateTime endOfSupportDate;

    @JsonProperty("releaseDateTime")
    protected OffsetDateTime releaseDateTime;

    protected WindowsUpdateCatalogItem() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The display name for the catalog item.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name for the catalog item.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsUpdateCatalogItem withDisplayName(String displayName) {
        WindowsUpdateCatalogItem _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateCatalogItem");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The last supported date for a catalog item”</i>
     * 
     * @return property endOfSupportDate
     */
    @Property(name="endOfSupportDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndOfSupportDate() {
        return Optional.ofNullable(endOfSupportDate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endOfSupportDate}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The last supported date for a catalog item”</i>
     * 
     * @param endOfSupportDate
     *            new value of {@code endOfSupportDate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endOfSupportDate} field changed
     */
    public WindowsUpdateCatalogItem withEndOfSupportDate(OffsetDateTime endOfSupportDate) {
        WindowsUpdateCatalogItem _x = _copy();
        _x.changedFields = changedFields.add("endOfSupportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateCatalogItem");
        _x.endOfSupportDate = endOfSupportDate;
        return _x;
    }

    /**
     * <i>“The date the catalog item was released”</i>
     * 
     * @return property releaseDateTime
     */
    @Property(name="releaseDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReleaseDateTime() {
        return Optional.ofNullable(releaseDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code releaseDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date the catalog item was released”</i>
     * 
     * @param releaseDateTime
     *            new value of {@code releaseDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code releaseDateTime} field changed
     */
    public WindowsUpdateCatalogItem withReleaseDateTime(OffsetDateTime releaseDateTime) {
        WindowsUpdateCatalogItem _x = _copy();
        _x.changedFields = changedFields.add("releaseDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateCatalogItem");
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    public WindowsUpdateCatalogItem withUnmappedField(String name, Object value) {
        WindowsUpdateCatalogItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUpdateCatalogItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsUpdateCatalogItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUpdateCatalogItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsUpdateCatalogItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsUpdateCatalogItem _copy() {
        WindowsUpdateCatalogItem _x = new WindowsUpdateCatalogItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.endOfSupportDate = endOfSupportDate;
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUpdateCatalogItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endOfSupportDate=");
        b.append(this.endOfSupportDate);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
