package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ExpeditedWindowsQualityUpdateSettings;
import odata.msgraph.client.beta.entity.collection.request.WindowsQualityUpdateProfileAssignmentCollectionRequest;


/**
 * <i>“Windows Quality Update Profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "deployableContentDisplayName", 
    "description", 
    "displayName", 
    "expeditedUpdateSettings", 
    "lastModifiedDateTime", 
    "releaseDateDisplayName", 
    "roleScopeTagIds", 
    "assignments"})
@JsonInclude(Include.NON_NULL)
public class WindowsQualityUpdateProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsQualityUpdateProfile";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deployableContentDisplayName")
    protected String deployableContentDisplayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("expeditedUpdateSettings")
    protected ExpeditedWindowsQualityUpdateSettings expeditedUpdateSettings;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("releaseDateDisplayName")
    protected String releaseDateDisplayName;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("assignments")
    protected List<WindowsQualityUpdateProfileAssignment> assignments;

    protected WindowsQualityUpdateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsQualityUpdateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String deployableContentDisplayName;
        private String description;
        private String displayName;
        private ExpeditedWindowsQualityUpdateSettings expeditedUpdateSettings;
        private OffsetDateTime lastModifiedDateTime;
        private String releaseDateDisplayName;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private List<WindowsQualityUpdateProfileAssignment> assignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The date time that the profile was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Friendly display name of the quality update profile deployable content”</i>
         * 
         * @param deployableContentDisplayName
         *            value of {@code deployableContentDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployableContentDisplayName(String deployableContentDisplayName) {
            this.deployableContentDisplayName = deployableContentDisplayName;
            this.changedFields = changedFields.add("deployableContentDisplayName");
            return this;
        }

        /**
         * <i>“The description of the profile which is specified by the user.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The display name for the profile.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Expedited update settings.”</i>
         * 
         * @param expeditedUpdateSettings
         *            value of {@code expeditedUpdateSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expeditedUpdateSettings(ExpeditedWindowsQualityUpdateSettings expeditedUpdateSettings) {
            this.expeditedUpdateSettings = expeditedUpdateSettings;
            this.changedFields = changedFields.add("expeditedUpdateSettings");
            return this;
        }

        /**
         * <i>“The date time that the profile was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Friendly release date to display for a Quality Update release”</i>
         * 
         * @param releaseDateDisplayName
         *            value of {@code releaseDateDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder releaseDateDisplayName(String releaseDateDisplayName) {
            this.releaseDateDisplayName = releaseDateDisplayName;
            this.changedFields = changedFields.add("releaseDateDisplayName");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Quality Update entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Quality Update entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Quality Update entity.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“The list of group assignments of the profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<WindowsQualityUpdateProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“The list of group assignments of the profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(WindowsQualityUpdateProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public WindowsQualityUpdateProfile build() {
            WindowsQualityUpdateProfile _x = new WindowsQualityUpdateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsQualityUpdateProfile";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.deployableContentDisplayName = deployableContentDisplayName;
            _x.description = description;
            _x.displayName = displayName;
            _x.expeditedUpdateSettings = expeditedUpdateSettings;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.releaseDateDisplayName = releaseDateDisplayName;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.assignments = assignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The date time that the profile was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date time that the profile was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public WindowsQualityUpdateProfile withCreatedDateTime(OffsetDateTime createdDateTime) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Friendly display name of the quality update profile deployable content”</i>
     * 
     * @return property deployableContentDisplayName
     */
    @Property(name="deployableContentDisplayName")
    @JsonIgnore
    public Optional<String> getDeployableContentDisplayName() {
        return Optional.ofNullable(deployableContentDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deployableContentDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly display name of the quality update profile deployable content”</i>
     * 
     * @param deployableContentDisplayName
     *            new value of {@code deployableContentDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployableContentDisplayName} field changed
     */
    public WindowsQualityUpdateProfile withDeployableContentDisplayName(String deployableContentDisplayName) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("deployableContentDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.deployableContentDisplayName = deployableContentDisplayName;
        return _x;
    }

    /**
     * <i>“The description of the profile which is specified by the user.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the profile which is specified by the user.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsQualityUpdateProfile withDescription(String description) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The display name for the profile.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name for the profile.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsQualityUpdateProfile withDisplayName(String displayName) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Expedited update settings.”</i>
     * 
     * @return property expeditedUpdateSettings
     */
    @Property(name="expeditedUpdateSettings")
    @JsonIgnore
    public Optional<ExpeditedWindowsQualityUpdateSettings> getExpeditedUpdateSettings() {
        return Optional.ofNullable(expeditedUpdateSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expeditedUpdateSettings} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Expedited update settings.”</i>
     * 
     * @param expeditedUpdateSettings
     *            new value of {@code expeditedUpdateSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expeditedUpdateSettings} field changed
     */
    public WindowsQualityUpdateProfile withExpeditedUpdateSettings(ExpeditedWindowsQualityUpdateSettings expeditedUpdateSettings) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("expeditedUpdateSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.expeditedUpdateSettings = expeditedUpdateSettings;
        return _x;
    }

    /**
     * <i>“The date time that the profile was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date time that the profile was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public WindowsQualityUpdateProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Friendly release date to display for a Quality Update release”</i>
     * 
     * @return property releaseDateDisplayName
     */
    @Property(name="releaseDateDisplayName")
    @JsonIgnore
    public Optional<String> getReleaseDateDisplayName() {
        return Optional.ofNullable(releaseDateDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * releaseDateDisplayName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly release date to display for a Quality Update release”</i>
     * 
     * @param releaseDateDisplayName
     *            new value of {@code releaseDateDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code releaseDateDisplayName} field changed
     */
    public WindowsQualityUpdateProfile withReleaseDateDisplayName(String releaseDateDisplayName) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("releaseDateDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.releaseDateDisplayName = releaseDateDisplayName;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Quality Update entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Quality Update entity.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public WindowsQualityUpdateProfile withRoleScopeTagIds(List<String> roleScopeTagIds) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Quality Update entity.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    public WindowsQualityUpdateProfile withUnmappedField(String name, Object value) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of group assignments of the profile.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public WindowsQualityUpdateProfileAssignmentCollectionRequest getAssignments() {
        return new WindowsQualityUpdateProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignments of the profile.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public WindowsQualityUpdateProfile withAssignments(List<WindowsQualityUpdateProfileAssignment> assignments) {
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateProfile");
        _x.assignments = assignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsQualityUpdateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsQualityUpdateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsQualityUpdateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsQualityUpdateProfile _copy() {
        WindowsQualityUpdateProfile _x = new WindowsQualityUpdateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.deployableContentDisplayName = deployableContentDisplayName;
        _x.description = description;
        _x.displayName = displayName;
        _x.expeditedUpdateSettings = expeditedUpdateSettings;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.releaseDateDisplayName = releaseDateDisplayName;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.assignments = assignments;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsQualityUpdateProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.windowsQualityUpdateProfileAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsQualityUpdateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deployableContentDisplayName=");
        b.append(this.deployableContentDisplayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("expeditedUpdateSettings=");
        b.append(this.expeditedUpdateSettings);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("releaseDateDisplayName=");
        b.append(this.releaseDateDisplayName);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
