package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsQualityUpdateClassification;


/**
 * <i>“Windows update catalog item entity”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "classification", 
    "isExpeditable", 
    "kbArticleId"})
@JsonInclude(Include.NON_NULL)
public class WindowsQualityUpdateCatalogItem extends WindowsUpdateCatalogItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsQualityUpdateCatalogItem";
    }

    @JsonProperty("classification")
    protected WindowsQualityUpdateClassification classification;

    @JsonProperty("isExpeditable")
    protected Boolean isExpeditable;

    @JsonProperty("kbArticleId")
    protected String kbArticleId;

    protected WindowsQualityUpdateCatalogItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsQualityUpdateCatalogItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private OffsetDateTime endOfSupportDate;
        private OffsetDateTime releaseDateTime;
        private WindowsQualityUpdateClassification classification;
        private Boolean isExpeditable;
        private String kbArticleId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder endOfSupportDate(OffsetDateTime endOfSupportDate) {
            this.endOfSupportDate = endOfSupportDate;
            this.changedFields = changedFields.add("endOfSupportDate");
            return this;
        }

        public Builder releaseDateTime(OffsetDateTime releaseDateTime) {
            this.releaseDateTime = releaseDateTime;
            this.changedFields = changedFields.add("releaseDateTime");
            return this;
        }

        /**
         * <i>“Classification of the quality update”</i>
         * 
         * @param classification
         *            value of {@code classification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classification(WindowsQualityUpdateClassification classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        /**
         * <i>“Flag indicating if update qualifies for expedite”</i>
         * 
         * @param isExpeditable
         *            value of {@code isExpeditable} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isExpeditable(Boolean isExpeditable) {
            this.isExpeditable = isExpeditable;
            this.changedFields = changedFields.add("isExpeditable");
            return this;
        }

        /**
         * <i>“Knowledge base article id”</i>
         * 
         * @param kbArticleId
         *            value of {@code kbArticleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kbArticleId(String kbArticleId) {
            this.kbArticleId = kbArticleId;
            this.changedFields = changedFields.add("kbArticleId");
            return this;
        }

        public WindowsQualityUpdateCatalogItem build() {
            WindowsQualityUpdateCatalogItem _x = new WindowsQualityUpdateCatalogItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsQualityUpdateCatalogItem";
            _x.id = id;
            _x.displayName = displayName;
            _x.endOfSupportDate = endOfSupportDate;
            _x.releaseDateTime = releaseDateTime;
            _x.classification = classification;
            _x.isExpeditable = isExpeditable;
            _x.kbArticleId = kbArticleId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Classification of the quality update”</i>
     * 
     * @return property classification
     */
    @Property(name="classification")
    @JsonIgnore
    public Optional<WindowsQualityUpdateClassification> getClassification() {
        return Optional.ofNullable(classification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code classification}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Classification of the quality update”</i>
     * 
     * @param classification
     *            new value of {@code classification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classification} field changed
     */
    public WindowsQualityUpdateCatalogItem withClassification(WindowsQualityUpdateClassification classification) {
        WindowsQualityUpdateCatalogItem _x = _copy();
        _x.changedFields = changedFields.add("classification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateCatalogItem");
        _x.classification = classification;
        return _x;
    }

    /**
     * <i>“Flag indicating if update qualifies for expedite”</i>
     * 
     * @return property isExpeditable
     */
    @Property(name="isExpeditable")
    @JsonIgnore
    public Optional<Boolean> getIsExpeditable() {
        return Optional.ofNullable(isExpeditable);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isExpeditable}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Flag indicating if update qualifies for expedite”</i>
     * 
     * @param isExpeditable
     *            new value of {@code isExpeditable} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isExpeditable} field changed
     */
    public WindowsQualityUpdateCatalogItem withIsExpeditable(Boolean isExpeditable) {
        WindowsQualityUpdateCatalogItem _x = _copy();
        _x.changedFields = changedFields.add("isExpeditable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateCatalogItem");
        _x.isExpeditable = isExpeditable;
        return _x;
    }

    /**
     * <i>“Knowledge base article id”</i>
     * 
     * @return property kbArticleId
     */
    @Property(name="kbArticleId")
    @JsonIgnore
    public Optional<String> getKbArticleId() {
        return Optional.ofNullable(kbArticleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code kbArticleId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Knowledge base article id”</i>
     * 
     * @param kbArticleId
     *            new value of {@code kbArticleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kbArticleId} field changed
     */
    public WindowsQualityUpdateCatalogItem withKbArticleId(String kbArticleId) {
        WindowsQualityUpdateCatalogItem _x = _copy();
        _x.changedFields = changedFields.add("kbArticleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsQualityUpdateCatalogItem");
        _x.kbArticleId = kbArticleId;
        return _x;
    }

    public WindowsQualityUpdateCatalogItem withUnmappedField(String name, Object value) {
        WindowsQualityUpdateCatalogItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsQualityUpdateCatalogItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsQualityUpdateCatalogItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsQualityUpdateCatalogItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsQualityUpdateCatalogItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsQualityUpdateCatalogItem _copy() {
        WindowsQualityUpdateCatalogItem _x = new WindowsQualityUpdateCatalogItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.endOfSupportDate = endOfSupportDate;
        _x.releaseDateTime = releaseDateTime;
        _x.classification = classification;
        _x.isExpeditable = isExpeditable;
        _x.kbArticleId = kbArticleId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsQualityUpdateCatalogItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endOfSupportDate=");
        b.append(this.endOfSupportDate);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append(", ");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("isExpeditable=");
        b.append(this.isExpeditable);
        b.append(", ");
        b.append("kbArticleId=");
        b.append(this.kbArticleId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
