package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WindowsDeviceMalwareStateCollectionRequest;
import odata.msgraph.client.beta.enums.WindowsDefenderProductStatus;
import odata.msgraph.client.beta.enums.WindowsDeviceHealthState;


/**
 * <i>“Device protection status entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "antiMalwareVersion", 
    "deviceState", 
    "engineVersion", 
    "fullScanOverdue", 
    "fullScanRequired", 
    "isVirtualMachine", 
    "lastFullScanDateTime", 
    "lastFullScanSignatureVersion", 
    "lastQuickScanDateTime", 
    "lastQuickScanSignatureVersion", 
    "lastReportedDateTime", 
    "malwareProtectionEnabled", 
    "networkInspectionSystemEnabled", 
    "productStatus", 
    "quickScanOverdue", 
    "realTimeProtectionEnabled", 
    "rebootRequired", 
    "signatureUpdateOverdue", 
    "signatureVersion", 
    "tamperProtectionEnabled", 
    "detectedMalwareState"})
@JsonInclude(Include.NON_NULL)
public class WindowsProtectionState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsProtectionState";
    }

    @JsonProperty("antiMalwareVersion")
    protected String antiMalwareVersion;

    @JsonProperty("deviceState")
    protected WindowsDeviceHealthState deviceState;

    @JsonProperty("engineVersion")
    protected String engineVersion;

    @JsonProperty("fullScanOverdue")
    protected Boolean fullScanOverdue;

    @JsonProperty("fullScanRequired")
    protected Boolean fullScanRequired;

    @JsonProperty("isVirtualMachine")
    protected Boolean isVirtualMachine;

    @JsonProperty("lastFullScanDateTime")
    protected OffsetDateTime lastFullScanDateTime;

    @JsonProperty("lastFullScanSignatureVersion")
    protected String lastFullScanSignatureVersion;

    @JsonProperty("lastQuickScanDateTime")
    protected OffsetDateTime lastQuickScanDateTime;

    @JsonProperty("lastQuickScanSignatureVersion")
    protected String lastQuickScanSignatureVersion;

    @JsonProperty("lastReportedDateTime")
    protected OffsetDateTime lastReportedDateTime;

    @JsonProperty("malwareProtectionEnabled")
    protected Boolean malwareProtectionEnabled;

    @JsonProperty("networkInspectionSystemEnabled")
    protected Boolean networkInspectionSystemEnabled;

    @JsonProperty("productStatus")
    protected WindowsDefenderProductStatus productStatus;

    @JsonProperty("quickScanOverdue")
    protected Boolean quickScanOverdue;

    @JsonProperty("realTimeProtectionEnabled")
    protected Boolean realTimeProtectionEnabled;

    @JsonProperty("rebootRequired")
    protected Boolean rebootRequired;

    @JsonProperty("signatureUpdateOverdue")
    protected Boolean signatureUpdateOverdue;

    @JsonProperty("signatureVersion")
    protected String signatureVersion;

    @JsonProperty("tamperProtectionEnabled")
    protected Boolean tamperProtectionEnabled;

    @JsonProperty("detectedMalwareState")
    protected List<WindowsDeviceMalwareState> detectedMalwareState;

    protected WindowsProtectionState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsProtectionState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String antiMalwareVersion;
        private WindowsDeviceHealthState deviceState;
        private String engineVersion;
        private Boolean fullScanOverdue;
        private Boolean fullScanRequired;
        private Boolean isVirtualMachine;
        private OffsetDateTime lastFullScanDateTime;
        private String lastFullScanSignatureVersion;
        private OffsetDateTime lastQuickScanDateTime;
        private String lastQuickScanSignatureVersion;
        private OffsetDateTime lastReportedDateTime;
        private Boolean malwareProtectionEnabled;
        private Boolean networkInspectionSystemEnabled;
        private WindowsDefenderProductStatus productStatus;
        private Boolean quickScanOverdue;
        private Boolean realTimeProtectionEnabled;
        private Boolean rebootRequired;
        private Boolean signatureUpdateOverdue;
        private String signatureVersion;
        private Boolean tamperProtectionEnabled;
        private List<WindowsDeviceMalwareState> detectedMalwareState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Current anti malware version”</i>
         * 
         * @param antiMalwareVersion
         *            value of {@code antiMalwareVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder antiMalwareVersion(String antiMalwareVersion) {
            this.antiMalwareVersion = antiMalwareVersion;
            this.changedFields = changedFields.add("antiMalwareVersion");
            return this;
        }

        /**
         * <i>“Computer's state (like clean or pending full scan or pending reboot etc)”</i>
         * 
         * @param deviceState
         *            value of {@code deviceState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceState(WindowsDeviceHealthState deviceState) {
            this.deviceState = deviceState;
            this.changedFields = changedFields.add("deviceState");
            return this;
        }

        /**
         * <i>“Current endpoint protection engine's version”</i>
         * 
         * @param engineVersion
         *            value of {@code engineVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            this.changedFields = changedFields.add("engineVersion");
            return this;
        }

        /**
         * <i>“Full scan overdue or not?”</i>
         * 
         * @param fullScanOverdue
         *            value of {@code fullScanOverdue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fullScanOverdue(Boolean fullScanOverdue) {
            this.fullScanOverdue = fullScanOverdue;
            this.changedFields = changedFields.add("fullScanOverdue");
            return this;
        }

        /**
         * <i>“Full scan required or not?”</i>
         * 
         * @param fullScanRequired
         *            value of {@code fullScanRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fullScanRequired(Boolean fullScanRequired) {
            this.fullScanRequired = fullScanRequired;
            this.changedFields = changedFields.add("fullScanRequired");
            return this;
        }

        /**
         * <i>“Indicates whether the device is a virtual machine.”</i>
         * 
         * @param isVirtualMachine
         *            value of {@code isVirtualMachine} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isVirtualMachine(Boolean isVirtualMachine) {
            this.isVirtualMachine = isVirtualMachine;
            this.changedFields = changedFields.add("isVirtualMachine");
            return this;
        }

        /**
         * <i>“Last quick scan datetime”</i>
         * 
         * @param lastFullScanDateTime
         *            value of {@code lastFullScanDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastFullScanDateTime(OffsetDateTime lastFullScanDateTime) {
            this.lastFullScanDateTime = lastFullScanDateTime;
            this.changedFields = changedFields.add("lastFullScanDateTime");
            return this;
        }

        /**
         * <i>“Last full scan signature version”</i>
         * 
         * @param lastFullScanSignatureVersion
         *            value of {@code lastFullScanSignatureVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastFullScanSignatureVersion(String lastFullScanSignatureVersion) {
            this.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
            this.changedFields = changedFields.add("lastFullScanSignatureVersion");
            return this;
        }

        /**
         * <i>“Last quick scan datetime”</i>
         * 
         * @param lastQuickScanDateTime
         *            value of {@code lastQuickScanDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastQuickScanDateTime(OffsetDateTime lastQuickScanDateTime) {
            this.lastQuickScanDateTime = lastQuickScanDateTime;
            this.changedFields = changedFields.add("lastQuickScanDateTime");
            return this;
        }

        /**
         * <i>“Last quick scan signature version”</i>
         * 
         * @param lastQuickScanSignatureVersion
         *            value of {@code lastQuickScanSignatureVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastQuickScanSignatureVersion(String lastQuickScanSignatureVersion) {
            this.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
            this.changedFields = changedFields.add("lastQuickScanSignatureVersion");
            return this;
        }

        /**
         * <i>“Last device health status reported time”</i>
         * 
         * @param lastReportedDateTime
         *            value of {@code lastReportedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastReportedDateTime(OffsetDateTime lastReportedDateTime) {
            this.lastReportedDateTime = lastReportedDateTime;
            this.changedFields = changedFields.add("lastReportedDateTime");
            return this;
        }

        /**
         * <i>“Anti malware is enabled or not”</i>
         * 
         * @param malwareProtectionEnabled
         *            value of {@code malwareProtectionEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareProtectionEnabled(Boolean malwareProtectionEnabled) {
            this.malwareProtectionEnabled = malwareProtectionEnabled;
            this.changedFields = changedFields.add("malwareProtectionEnabled");
            return this;
        }

        /**
         * <i>“Network inspection system enabled or not?”</i>
         * 
         * @param networkInspectionSystemEnabled
         *            value of {@code networkInspectionSystemEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkInspectionSystemEnabled(Boolean networkInspectionSystemEnabled) {
            this.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
            this.changedFields = changedFields.add("networkInspectionSystemEnabled");
            return this;
        }

        /**
         * <i>“Product Status of Windows Defender Antivirus”</i>
         * 
         * @param productStatus
         *            value of {@code productStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productStatus(WindowsDefenderProductStatus productStatus) {
            this.productStatus = productStatus;
            this.changedFields = changedFields.add("productStatus");
            return this;
        }

        /**
         * <i>“Quick scan overdue or not?”</i>
         * 
         * @param quickScanOverdue
         *            value of {@code quickScanOverdue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder quickScanOverdue(Boolean quickScanOverdue) {
            this.quickScanOverdue = quickScanOverdue;
            this.changedFields = changedFields.add("quickScanOverdue");
            return this;
        }

        /**
         * <i>“Real time protection is enabled or not?”</i>
         * 
         * @param realTimeProtectionEnabled
         *            value of {@code realTimeProtectionEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder realTimeProtectionEnabled(Boolean realTimeProtectionEnabled) {
            this.realTimeProtectionEnabled = realTimeProtectionEnabled;
            this.changedFields = changedFields.add("realTimeProtectionEnabled");
            return this;
        }

        /**
         * <i>“Reboot required or not?”</i>
         * 
         * @param rebootRequired
         *            value of {@code rebootRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rebootRequired(Boolean rebootRequired) {
            this.rebootRequired = rebootRequired;
            this.changedFields = changedFields.add("rebootRequired");
            return this;
        }

        /**
         * <i>“Signature out of date or not?”</i>
         * 
         * @param signatureUpdateOverdue
         *            value of {@code signatureUpdateOverdue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder signatureUpdateOverdue(Boolean signatureUpdateOverdue) {
            this.signatureUpdateOverdue = signatureUpdateOverdue;
            this.changedFields = changedFields.add("signatureUpdateOverdue");
            return this;
        }

        /**
         * <i>“Current malware definitions version”</i>
         * 
         * @param signatureVersion
         *            value of {@code signatureVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder signatureVersion(String signatureVersion) {
            this.signatureVersion = signatureVersion;
            this.changedFields = changedFields.add("signatureVersion");
            return this;
        }

        /**
         * <i>“Indicates whether the Windows Defender tamper protection feature is enabled.”</i>
         * 
         * @param tamperProtectionEnabled
         *            value of {@code tamperProtectionEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tamperProtectionEnabled(Boolean tamperProtectionEnabled) {
            this.tamperProtectionEnabled = tamperProtectionEnabled;
            this.changedFields = changedFields.add("tamperProtectionEnabled");
            return this;
        }

        /**
         * <i>“Device malware list”</i>
         * 
         * @param detectedMalwareState
         *            value of {@code detectedMalwareState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectedMalwareState(List<WindowsDeviceMalwareState> detectedMalwareState) {
            this.detectedMalwareState = detectedMalwareState;
            this.changedFields = changedFields.add("detectedMalwareState");
            return this;
        }

        /**
         * <i>“Device malware list”</i>
         * 
         * @param detectedMalwareState
         *            value of {@code detectedMalwareState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectedMalwareState(WindowsDeviceMalwareState... detectedMalwareState) {
            return detectedMalwareState(Arrays.asList(detectedMalwareState));
        }

        public WindowsProtectionState build() {
            WindowsProtectionState _x = new WindowsProtectionState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsProtectionState";
            _x.id = id;
            _x.antiMalwareVersion = antiMalwareVersion;
            _x.deviceState = deviceState;
            _x.engineVersion = engineVersion;
            _x.fullScanOverdue = fullScanOverdue;
            _x.fullScanRequired = fullScanRequired;
            _x.isVirtualMachine = isVirtualMachine;
            _x.lastFullScanDateTime = lastFullScanDateTime;
            _x.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
            _x.lastQuickScanDateTime = lastQuickScanDateTime;
            _x.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
            _x.lastReportedDateTime = lastReportedDateTime;
            _x.malwareProtectionEnabled = malwareProtectionEnabled;
            _x.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
            _x.productStatus = productStatus;
            _x.quickScanOverdue = quickScanOverdue;
            _x.realTimeProtectionEnabled = realTimeProtectionEnabled;
            _x.rebootRequired = rebootRequired;
            _x.signatureUpdateOverdue = signatureUpdateOverdue;
            _x.signatureVersion = signatureVersion;
            _x.tamperProtectionEnabled = tamperProtectionEnabled;
            _x.detectedMalwareState = detectedMalwareState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Current anti malware version”</i>
     * 
     * @return property antiMalwareVersion
     */
    @Property(name="antiMalwareVersion")
    @JsonIgnore
    public Optional<String> getAntiMalwareVersion() {
        return Optional.ofNullable(antiMalwareVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * antiMalwareVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Current anti malware version”</i>
     * 
     * @param antiMalwareVersion
     *            new value of {@code antiMalwareVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code antiMalwareVersion} field changed
     */
    public WindowsProtectionState withAntiMalwareVersion(String antiMalwareVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("antiMalwareVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.antiMalwareVersion = antiMalwareVersion;
        return _x;
    }

    /**
     * <i>“Computer's state (like clean or pending full scan or pending reboot etc)”</i>
     * 
     * @return property deviceState
     */
    @Property(name="deviceState")
    @JsonIgnore
    public Optional<WindowsDeviceHealthState> getDeviceState() {
        return Optional.ofNullable(deviceState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Computer's state (like clean or pending full scan or pending reboot etc)”</i>
     * 
     * @param deviceState
     *            new value of {@code deviceState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceState} field changed
     */
    public WindowsProtectionState withDeviceState(WindowsDeviceHealthState deviceState) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("deviceState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.deviceState = deviceState;
        return _x;
    }

    /**
     * <i>“Current endpoint protection engine's version”</i>
     * 
     * @return property engineVersion
     */
    @Property(name="engineVersion")
    @JsonIgnore
    public Optional<String> getEngineVersion() {
        return Optional.ofNullable(engineVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code engineVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Current endpoint protection engine's version”</i>
     * 
     * @param engineVersion
     *            new value of {@code engineVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code engineVersion} field changed
     */
    public WindowsProtectionState withEngineVersion(String engineVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("engineVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.engineVersion = engineVersion;
        return _x;
    }

    /**
     * <i>“Full scan overdue or not?”</i>
     * 
     * @return property fullScanOverdue
     */
    @Property(name="fullScanOverdue")
    @JsonIgnore
    public Optional<Boolean> getFullScanOverdue() {
        return Optional.ofNullable(fullScanOverdue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fullScanOverdue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Full scan overdue or not?”</i>
     * 
     * @param fullScanOverdue
     *            new value of {@code fullScanOverdue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fullScanOverdue} field changed
     */
    public WindowsProtectionState withFullScanOverdue(Boolean fullScanOverdue) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("fullScanOverdue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.fullScanOverdue = fullScanOverdue;
        return _x;
    }

    /**
     * <i>“Full scan required or not?”</i>
     * 
     * @return property fullScanRequired
     */
    @Property(name="fullScanRequired")
    @JsonIgnore
    public Optional<Boolean> getFullScanRequired() {
        return Optional.ofNullable(fullScanRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fullScanRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Full scan required or not?”</i>
     * 
     * @param fullScanRequired
     *            new value of {@code fullScanRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fullScanRequired} field changed
     */
    public WindowsProtectionState withFullScanRequired(Boolean fullScanRequired) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("fullScanRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.fullScanRequired = fullScanRequired;
        return _x;
    }

    /**
     * <i>“Indicates whether the device is a virtual machine.”</i>
     * 
     * @return property isVirtualMachine
     */
    @Property(name="isVirtualMachine")
    @JsonIgnore
    public Optional<Boolean> getIsVirtualMachine() {
        return Optional.ofNullable(isVirtualMachine);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isVirtualMachine}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether the device is a virtual machine.”</i>
     * 
     * @param isVirtualMachine
     *            new value of {@code isVirtualMachine} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isVirtualMachine} field changed
     */
    public WindowsProtectionState withIsVirtualMachine(Boolean isVirtualMachine) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("isVirtualMachine");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.isVirtualMachine = isVirtualMachine;
        return _x;
    }

    /**
     * <i>“Last quick scan datetime”</i>
     * 
     * @return property lastFullScanDateTime
     */
    @Property(name="lastFullScanDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastFullScanDateTime() {
        return Optional.ofNullable(lastFullScanDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastFullScanDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last quick scan datetime”</i>
     * 
     * @param lastFullScanDateTime
     *            new value of {@code lastFullScanDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastFullScanDateTime} field changed
     */
    public WindowsProtectionState withLastFullScanDateTime(OffsetDateTime lastFullScanDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastFullScanDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.lastFullScanDateTime = lastFullScanDateTime;
        return _x;
    }

    /**
     * <i>“Last full scan signature version”</i>
     * 
     * @return property lastFullScanSignatureVersion
     */
    @Property(name="lastFullScanSignatureVersion")
    @JsonIgnore
    public Optional<String> getLastFullScanSignatureVersion() {
        return Optional.ofNullable(lastFullScanSignatureVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastFullScanSignatureVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Last full scan signature version”</i>
     * 
     * @param lastFullScanSignatureVersion
     *            new value of {@code lastFullScanSignatureVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastFullScanSignatureVersion} field changed
     */
    public WindowsProtectionState withLastFullScanSignatureVersion(String lastFullScanSignatureVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastFullScanSignatureVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
        return _x;
    }

    /**
     * <i>“Last quick scan datetime”</i>
     * 
     * @return property lastQuickScanDateTime
     */
    @Property(name="lastQuickScanDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastQuickScanDateTime() {
        return Optional.ofNullable(lastQuickScanDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastQuickScanDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last quick scan datetime”</i>
     * 
     * @param lastQuickScanDateTime
     *            new value of {@code lastQuickScanDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastQuickScanDateTime} field changed
     */
    public WindowsProtectionState withLastQuickScanDateTime(OffsetDateTime lastQuickScanDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastQuickScanDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.lastQuickScanDateTime = lastQuickScanDateTime;
        return _x;
    }

    /**
     * <i>“Last quick scan signature version”</i>
     * 
     * @return property lastQuickScanSignatureVersion
     */
    @Property(name="lastQuickScanSignatureVersion")
    @JsonIgnore
    public Optional<String> getLastQuickScanSignatureVersion() {
        return Optional.ofNullable(lastQuickScanSignatureVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastQuickScanSignatureVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Last quick scan signature version”</i>
     * 
     * @param lastQuickScanSignatureVersion
     *            new value of {@code lastQuickScanSignatureVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastQuickScanSignatureVersion} field changed
     */
    public WindowsProtectionState withLastQuickScanSignatureVersion(String lastQuickScanSignatureVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastQuickScanSignatureVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
        return _x;
    }

    /**
     * <i>“Last device health status reported time”</i>
     * 
     * @return property lastReportedDateTime
     */
    @Property(name="lastReportedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportedDateTime() {
        return Optional.ofNullable(lastReportedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastReportedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last device health status reported time”</i>
     * 
     * @param lastReportedDateTime
     *            new value of {@code lastReportedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastReportedDateTime} field changed
     */
    public WindowsProtectionState withLastReportedDateTime(OffsetDateTime lastReportedDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastReportedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.lastReportedDateTime = lastReportedDateTime;
        return _x;
    }

    /**
     * <i>“Anti malware is enabled or not”</i>
     * 
     * @return property malwareProtectionEnabled
     */
    @Property(name="malwareProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getMalwareProtectionEnabled() {
        return Optional.ofNullable(malwareProtectionEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * malwareProtectionEnabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Anti malware is enabled or not”</i>
     * 
     * @param malwareProtectionEnabled
     *            new value of {@code malwareProtectionEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code malwareProtectionEnabled} field changed
     */
    public WindowsProtectionState withMalwareProtectionEnabled(Boolean malwareProtectionEnabled) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("malwareProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.malwareProtectionEnabled = malwareProtectionEnabled;
        return _x;
    }

    /**
     * <i>“Network inspection system enabled or not?”</i>
     * 
     * @return property networkInspectionSystemEnabled
     */
    @Property(name="networkInspectionSystemEnabled")
    @JsonIgnore
    public Optional<Boolean> getNetworkInspectionSystemEnabled() {
        return Optional.ofNullable(networkInspectionSystemEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * networkInspectionSystemEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Network inspection system enabled or not?”</i>
     * 
     * @param networkInspectionSystemEnabled
     *            new value of {@code networkInspectionSystemEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkInspectionSystemEnabled} field changed
     */
    public WindowsProtectionState withNetworkInspectionSystemEnabled(Boolean networkInspectionSystemEnabled) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("networkInspectionSystemEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
        return _x;
    }

    /**
     * <i>“Product Status of Windows Defender Antivirus”</i>
     * 
     * @return property productStatus
     */
    @Property(name="productStatus")
    @JsonIgnore
    public Optional<WindowsDefenderProductStatus> getProductStatus() {
        return Optional.ofNullable(productStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Product Status of Windows Defender Antivirus”</i>
     * 
     * @param productStatus
     *            new value of {@code productStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productStatus} field changed
     */
    public WindowsProtectionState withProductStatus(WindowsDefenderProductStatus productStatus) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("productStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.productStatus = productStatus;
        return _x;
    }

    /**
     * <i>“Quick scan overdue or not?”</i>
     * 
     * @return property quickScanOverdue
     */
    @Property(name="quickScanOverdue")
    @JsonIgnore
    public Optional<Boolean> getQuickScanOverdue() {
        return Optional.ofNullable(quickScanOverdue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code quickScanOverdue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Quick scan overdue or not?”</i>
     * 
     * @param quickScanOverdue
     *            new value of {@code quickScanOverdue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code quickScanOverdue} field changed
     */
    public WindowsProtectionState withQuickScanOverdue(Boolean quickScanOverdue) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("quickScanOverdue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.quickScanOverdue = quickScanOverdue;
        return _x;
    }

    /**
     * <i>“Real time protection is enabled or not?”</i>
     * 
     * @return property realTimeProtectionEnabled
     */
    @Property(name="realTimeProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getRealTimeProtectionEnabled() {
        return Optional.ofNullable(realTimeProtectionEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * realTimeProtectionEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Real time protection is enabled or not?”</i>
     * 
     * @param realTimeProtectionEnabled
     *            new value of {@code realTimeProtectionEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code realTimeProtectionEnabled} field changed
     */
    public WindowsProtectionState withRealTimeProtectionEnabled(Boolean realTimeProtectionEnabled) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("realTimeProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.realTimeProtectionEnabled = realTimeProtectionEnabled;
        return _x;
    }

    /**
     * <i>“Reboot required or not?”</i>
     * 
     * @return property rebootRequired
     */
    @Property(name="rebootRequired")
    @JsonIgnore
    public Optional<Boolean> getRebootRequired() {
        return Optional.ofNullable(rebootRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rebootRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Reboot required or not?”</i>
     * 
     * @param rebootRequired
     *            new value of {@code rebootRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rebootRequired} field changed
     */
    public WindowsProtectionState withRebootRequired(Boolean rebootRequired) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("rebootRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.rebootRequired = rebootRequired;
        return _x;
    }

    /**
     * <i>“Signature out of date or not?”</i>
     * 
     * @return property signatureUpdateOverdue
     */
    @Property(name="signatureUpdateOverdue")
    @JsonIgnore
    public Optional<Boolean> getSignatureUpdateOverdue() {
        return Optional.ofNullable(signatureUpdateOverdue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * signatureUpdateOverdue} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Signature out of date or not?”</i>
     * 
     * @param signatureUpdateOverdue
     *            new value of {@code signatureUpdateOverdue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code signatureUpdateOverdue} field changed
     */
    public WindowsProtectionState withSignatureUpdateOverdue(Boolean signatureUpdateOverdue) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("signatureUpdateOverdue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.signatureUpdateOverdue = signatureUpdateOverdue;
        return _x;
    }

    /**
     * <i>“Current malware definitions version”</i>
     * 
     * @return property signatureVersion
     */
    @Property(name="signatureVersion")
    @JsonIgnore
    public Optional<String> getSignatureVersion() {
        return Optional.ofNullable(signatureVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code signatureVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Current malware definitions version”</i>
     * 
     * @param signatureVersion
     *            new value of {@code signatureVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code signatureVersion} field changed
     */
    public WindowsProtectionState withSignatureVersion(String signatureVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("signatureVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.signatureVersion = signatureVersion;
        return _x;
    }

    /**
     * <i>“Indicates whether the Windows Defender tamper protection feature is enabled.”</i>
     * 
     * @return property tamperProtectionEnabled
     */
    @Property(name="tamperProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getTamperProtectionEnabled() {
        return Optional.ofNullable(tamperProtectionEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tamperProtectionEnabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether the Windows Defender tamper protection feature is enabled.”</i>
     * 
     * @param tamperProtectionEnabled
     *            new value of {@code tamperProtectionEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tamperProtectionEnabled} field changed
     */
    public WindowsProtectionState withTamperProtectionEnabled(Boolean tamperProtectionEnabled) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("tamperProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.tamperProtectionEnabled = tamperProtectionEnabled;
        return _x;
    }

    public WindowsProtectionState withUnmappedField(String name, Object value) {
        WindowsProtectionState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Device malware list”</i>
     * 
     * @return navigational property detectedMalwareState
     */
    @NavigationProperty(name="detectedMalwareState")
    @JsonIgnore
    public WindowsDeviceMalwareStateCollectionRequest getDetectedMalwareState() {
        return new WindowsDeviceMalwareStateCollectionRequest(
                        contextPath.addSegment("detectedMalwareState"), Optional.ofNullable(detectedMalwareState));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectedMalwareState} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device malware list”</i>
     * 
     * @param detectedMalwareState
     *            new value of {@code detectedMalwareState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectedMalwareState} field changed
     */
    public WindowsProtectionState withDetectedMalwareState(List<WindowsDeviceMalwareState> detectedMalwareState) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("detectedMalwareState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsProtectionState");
        _x.detectedMalwareState = detectedMalwareState;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsProtectionState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsProtectionState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsProtectionState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsProtectionState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsProtectionState _copy() {
        WindowsProtectionState _x = new WindowsProtectionState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.antiMalwareVersion = antiMalwareVersion;
        _x.deviceState = deviceState;
        _x.engineVersion = engineVersion;
        _x.fullScanOverdue = fullScanOverdue;
        _x.fullScanRequired = fullScanRequired;
        _x.isVirtualMachine = isVirtualMachine;
        _x.lastFullScanDateTime = lastFullScanDateTime;
        _x.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
        _x.lastQuickScanDateTime = lastQuickScanDateTime;
        _x.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
        _x.lastReportedDateTime = lastReportedDateTime;
        _x.malwareProtectionEnabled = malwareProtectionEnabled;
        _x.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
        _x.productStatus = productStatus;
        _x.quickScanOverdue = quickScanOverdue;
        _x.realTimeProtectionEnabled = realTimeProtectionEnabled;
        _x.rebootRequired = rebootRequired;
        _x.signatureUpdateOverdue = signatureUpdateOverdue;
        _x.signatureVersion = signatureVersion;
        _x.tamperProtectionEnabled = tamperProtectionEnabled;
        _x.detectedMalwareState = detectedMalwareState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsProtectionState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("antiMalwareVersion=");
        b.append(this.antiMalwareVersion);
        b.append(", ");
        b.append("deviceState=");
        b.append(this.deviceState);
        b.append(", ");
        b.append("engineVersion=");
        b.append(this.engineVersion);
        b.append(", ");
        b.append("fullScanOverdue=");
        b.append(this.fullScanOverdue);
        b.append(", ");
        b.append("fullScanRequired=");
        b.append(this.fullScanRequired);
        b.append(", ");
        b.append("isVirtualMachine=");
        b.append(this.isVirtualMachine);
        b.append(", ");
        b.append("lastFullScanDateTime=");
        b.append(this.lastFullScanDateTime);
        b.append(", ");
        b.append("lastFullScanSignatureVersion=");
        b.append(this.lastFullScanSignatureVersion);
        b.append(", ");
        b.append("lastQuickScanDateTime=");
        b.append(this.lastQuickScanDateTime);
        b.append(", ");
        b.append("lastQuickScanSignatureVersion=");
        b.append(this.lastQuickScanSignatureVersion);
        b.append(", ");
        b.append("lastReportedDateTime=");
        b.append(this.lastReportedDateTime);
        b.append(", ");
        b.append("malwareProtectionEnabled=");
        b.append(this.malwareProtectionEnabled);
        b.append(", ");
        b.append("networkInspectionSystemEnabled=");
        b.append(this.networkInspectionSystemEnabled);
        b.append(", ");
        b.append("productStatus=");
        b.append(this.productStatus);
        b.append(", ");
        b.append("quickScanOverdue=");
        b.append(this.quickScanOverdue);
        b.append(", ");
        b.append("realTimeProtectionEnabled=");
        b.append(this.realTimeProtectionEnabled);
        b.append(", ");
        b.append("rebootRequired=");
        b.append(this.rebootRequired);
        b.append(", ");
        b.append("signatureUpdateOverdue=");
        b.append(this.signatureUpdateOverdue);
        b.append(", ");
        b.append("signatureVersion=");
        b.append(this.signatureVersion);
        b.append(", ");
        b.append("tamperProtectionEnabled=");
        b.append(this.tamperProtectionEnabled);
        b.append(", ");
        b.append("detectedMalwareState=");
        b.append(this.detectedMalwareState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
