package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.AppListType;
import odata.msgraph.client.beta.enums.RequiredPasswordType;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the windowsPhone81GeneralConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applyOnlyToWindowsPhone81", 
    "appsBlockCopyPaste", 
    "bluetoothBlocked", 
    "cameraBlocked", 
    "cellularBlockWifiTethering", 
    "compliantAppListType", 
    "compliantAppsList", 
    "diagnosticDataBlockSubmission", 
    "emailBlockAddingAccounts", 
    "locationServicesBlocked", 
    "microsoftAccountBlocked", 
    "nfcBlocked", 
    "passwordBlockSimple", 
    "passwordExpirationDays", 
    "passwordMinimumCharacterSetCount", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeScreenTimeout", 
    "passwordPreviousPasswordBlockCount", 
    "passwordRequired", 
    "passwordRequiredType", 
    "passwordSignInFailureCountBeforeFactoryReset", 
    "screenCaptureBlocked", 
    "storageBlockRemovableStorage", 
    "storageRequireEncryption", 
    "webBrowserBlocked", 
    "wifiBlockAutomaticConnectHotspots", 
    "wifiBlocked", 
    "wifiBlockHotspotReporting", 
    "windowsStoreBlocked"})
@JsonInclude(Include.NON_NULL)
public class WindowsPhone81GeneralConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsPhone81GeneralConfiguration";
    }

    @JsonProperty("applyOnlyToWindowsPhone81")
    protected Boolean applyOnlyToWindowsPhone81;

    @JsonProperty("appsBlockCopyPaste")
    protected Boolean appsBlockCopyPaste;

    @JsonProperty("bluetoothBlocked")
    protected Boolean bluetoothBlocked;

    @JsonProperty("cameraBlocked")
    protected Boolean cameraBlocked;

    @JsonProperty("cellularBlockWifiTethering")
    protected Boolean cellularBlockWifiTethering;

    @JsonProperty("compliantAppListType")
    protected AppListType compliantAppListType;

    @JsonProperty("compliantAppsList")
    protected List<AppListItem> compliantAppsList;

    @JsonProperty("compliantAppsList@nextLink")
    protected String compliantAppsListNextLink;

    @JsonProperty("diagnosticDataBlockSubmission")
    protected Boolean diagnosticDataBlockSubmission;

    @JsonProperty("emailBlockAddingAccounts")
    protected Boolean emailBlockAddingAccounts;

    @JsonProperty("locationServicesBlocked")
    protected Boolean locationServicesBlocked;

    @JsonProperty("microsoftAccountBlocked")
    protected Boolean microsoftAccountBlocked;

    @JsonProperty("nfcBlocked")
    protected Boolean nfcBlocked;

    @JsonProperty("passwordBlockSimple")
    protected Boolean passwordBlockSimple;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumCharacterSetCount")
    protected Integer passwordMinimumCharacterSetCount;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordRequiredType")
    protected RequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordSignInFailureCountBeforeFactoryReset")
    protected Integer passwordSignInFailureCountBeforeFactoryReset;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("storageBlockRemovableStorage")
    protected Boolean storageBlockRemovableStorage;

    @JsonProperty("storageRequireEncryption")
    protected Boolean storageRequireEncryption;

    @JsonProperty("webBrowserBlocked")
    protected Boolean webBrowserBlocked;

    @JsonProperty("wifiBlockAutomaticConnectHotspots")
    protected Boolean wifiBlockAutomaticConnectHotspots;

    @JsonProperty("wifiBlocked")
    protected Boolean wifiBlocked;

    @JsonProperty("wifiBlockHotspotReporting")
    protected Boolean wifiBlockHotspotReporting;

    @JsonProperty("windowsStoreBlocked")
    protected Boolean windowsStoreBlocked;

    protected WindowsPhone81GeneralConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsPhone81GeneralConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean applyOnlyToWindowsPhone81;
        private Boolean appsBlockCopyPaste;
        private Boolean bluetoothBlocked;
        private Boolean cameraBlocked;
        private Boolean cellularBlockWifiTethering;
        private AppListType compliantAppListType;
        private List<AppListItem> compliantAppsList;
        private String compliantAppsListNextLink;
        private Boolean diagnosticDataBlockSubmission;
        private Boolean emailBlockAddingAccounts;
        private Boolean locationServicesBlocked;
        private Boolean microsoftAccountBlocked;
        private Boolean nfcBlocked;
        private Boolean passwordBlockSimple;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumCharacterSetCount;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeScreenTimeout;
        private Integer passwordPreviousPasswordBlockCount;
        private Boolean passwordRequired;
        private RequiredPasswordType passwordRequiredType;
        private Integer passwordSignInFailureCountBeforeFactoryReset;
        private Boolean screenCaptureBlocked;
        private Boolean storageBlockRemovableStorage;
        private Boolean storageRequireEncryption;
        private Boolean webBrowserBlocked;
        private Boolean wifiBlockAutomaticConnectHotspots;
        private Boolean wifiBlocked;
        private Boolean wifiBlockHotspotReporting;
        private Boolean windowsStoreBlocked;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Value indicating whether this policy only applies to Windows Phone 8.1. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param applyOnlyToWindowsPhone81
         *            value of {@code applyOnlyToWindowsPhone81} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applyOnlyToWindowsPhone81(Boolean applyOnlyToWindowsPhone81) {
            this.applyOnlyToWindowsPhone81 = applyOnlyToWindowsPhone81;
            this.changedFields = changedFields.add("applyOnlyToWindowsPhone81");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block copy paste.”</i>
         * 
         * @param appsBlockCopyPaste
         *            value of {@code appsBlockCopyPaste} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsBlockCopyPaste(Boolean appsBlockCopyPaste) {
            this.appsBlockCopyPaste = appsBlockCopyPaste;
            this.changedFields = changedFields.add("appsBlockCopyPaste");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block bluetooth.”</i>
         * 
         * @param bluetoothBlocked
         *            value of {@code bluetoothBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlocked(Boolean bluetoothBlocked) {
            this.bluetoothBlocked = bluetoothBlocked;
            this.changedFields = changedFields.add("bluetoothBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block camera.”</i>
         * 
         * @param cameraBlocked
         *            value of {@code cameraBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameraBlocked(Boolean cameraBlocked) {
            this.cameraBlocked = cameraBlocked;
            this.changedFields = changedFields.add("cameraBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Wi-Fi tethering. Has no impact if Wi-Fi is
         * blocked.”</i>
         * 
         * @param cellularBlockWifiTethering
         *            value of {@code cellularBlockWifiTethering} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockWifiTethering(Boolean cellularBlockWifiTethering) {
            this.cellularBlockWifiTethering = cellularBlockWifiTethering;
            this.changedFields = changedFields.add("cellularBlockWifiTethering");
            return this;
        }

        /**
         * <i>“List that is in the AppComplianceList.”</i>
         * 
         * @param compliantAppListType
         *            value of {@code compliantAppListType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppListType(AppListType compliantAppListType) {
            this.compliantAppListType = compliantAppListType;
            this.changedFields = changedFields.add("compliantAppListType");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(List<AppListItem> compliantAppsList) {
            this.compliantAppsList = compliantAppsList;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(AppListItem... compliantAppsList) {
            return compliantAppsList(Arrays.asList(compliantAppsList));
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsListNextLink
         *            value of {@code compliantAppsList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsListNextLink(String compliantAppsListNextLink) {
            this.compliantAppsListNextLink = compliantAppsListNextLink;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block diagnostic data submission.”</i>
         * 
         * @param diagnosticDataBlockSubmission
         *            value of {@code diagnosticDataBlockSubmission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diagnosticDataBlockSubmission(Boolean diagnosticDataBlockSubmission) {
            this.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
            this.changedFields = changedFields.add("diagnosticDataBlockSubmission");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block custom email accounts.”</i>
         * 
         * @param emailBlockAddingAccounts
         *            value of {@code emailBlockAddingAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailBlockAddingAccounts(Boolean emailBlockAddingAccounts) {
            this.emailBlockAddingAccounts = emailBlockAddingAccounts;
            this.changedFields = changedFields.add("emailBlockAddingAccounts");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block location services.”</i>
         * 
         * @param locationServicesBlocked
         *            value of {@code locationServicesBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder locationServicesBlocked(Boolean locationServicesBlocked) {
            this.locationServicesBlocked = locationServicesBlocked;
            this.changedFields = changedFields.add("locationServicesBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block using a Microsoft Account.”</i>
         * 
         * @param microsoftAccountBlocked
         *            value of {@code microsoftAccountBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftAccountBlocked(Boolean microsoftAccountBlocked) {
            this.microsoftAccountBlocked = microsoftAccountBlocked;
            this.changedFields = changedFields.add("microsoftAccountBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Near-Field Communication.”</i>
         * 
         * @param nfcBlocked
         *            value of {@code nfcBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nfcBlocked(Boolean nfcBlocked) {
            this.nfcBlocked = nfcBlocked;
            this.changedFields = changedFields.add("nfcBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block syncing the calendar.”</i>
         * 
         * @param passwordBlockSimple
         *            value of {@code passwordBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockSimple(Boolean passwordBlockSimple) {
            this.passwordBlockSimple = passwordBlockSimple;
            this.changedFields = changedFields.add("passwordBlockSimple");
            return this;
        }

        /**
         * <i>“Number of days before the password expires.”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“Number of character sets a password must contain.”</i>
         * 
         * @param passwordMinimumCharacterSetCount
         *            value of {@code passwordMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
            this.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“Minimum length of passwords.”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before screen timeout.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
            this.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“Number of previous passwords to block. Valid values 0 to 24”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a password.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Password type that is required.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(RequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“Number of sign in failures allowed before factory reset.”</i>
         * 
         * @param passwordSignInFailureCountBeforeFactoryReset
         *            value of {@code passwordSignInFailureCountBeforeFactoryReset} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
            this.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            this.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block screenshots.”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block removable storage.”</i>
         * 
         * @param storageBlockRemovableStorage
         *            value of {@code storageBlockRemovableStorage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockRemovableStorage(Boolean storageBlockRemovableStorage) {
            this.storageBlockRemovableStorage = storageBlockRemovableStorage;
            this.changedFields = changedFields.add("storageBlockRemovableStorage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require encryption.”</i>
         * 
         * @param storageRequireEncryption
         *            value of {@code storageRequireEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireEncryption(Boolean storageRequireEncryption) {
            this.storageRequireEncryption = storageRequireEncryption;
            this.changedFields = changedFields.add("storageRequireEncryption");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the web browser.”</i>
         * 
         * @param webBrowserBlocked
         *            value of {@code webBrowserBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webBrowserBlocked(Boolean webBrowserBlocked) {
            this.webBrowserBlocked = webBrowserBlocked;
            this.changedFields = changedFields.add("webBrowserBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block automatically connecting to Wi-Fi hotspots.
         * Has no impact if Wi-Fi is blocked.”</i>
         * 
         * @param wifiBlockAutomaticConnectHotspots
         *            value of {@code wifiBlockAutomaticConnectHotspots} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiBlockAutomaticConnectHotspots(Boolean wifiBlockAutomaticConnectHotspots) {
            this.wifiBlockAutomaticConnectHotspots = wifiBlockAutomaticConnectHotspots;
            this.changedFields = changedFields.add("wifiBlockAutomaticConnectHotspots");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Wi-Fi.”</i>
         * 
         * @param wifiBlocked
         *            value of {@code wifiBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiBlocked(Boolean wifiBlocked) {
            this.wifiBlocked = wifiBlocked;
            this.changedFields = changedFields.add("wifiBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Wi-Fi hotspot reporting. Has no impact if Wi-
         * Fi is blocked.”</i>
         * 
         * @param wifiBlockHotspotReporting
         *            value of {@code wifiBlockHotspotReporting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiBlockHotspotReporting(Boolean wifiBlockHotspotReporting) {
            this.wifiBlockHotspotReporting = wifiBlockHotspotReporting;
            this.changedFields = changedFields.add("wifiBlockHotspotReporting");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the Windows Store.”</i>
         * 
         * @param windowsStoreBlocked
         *            value of {@code windowsStoreBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsStoreBlocked(Boolean windowsStoreBlocked) {
            this.windowsStoreBlocked = windowsStoreBlocked;
            this.changedFields = changedFields.add("windowsStoreBlocked");
            return this;
        }

        public WindowsPhone81GeneralConfiguration build() {
            WindowsPhone81GeneralConfiguration _x = new WindowsPhone81GeneralConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsPhone81GeneralConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.applyOnlyToWindowsPhone81 = applyOnlyToWindowsPhone81;
            _x.appsBlockCopyPaste = appsBlockCopyPaste;
            _x.bluetoothBlocked = bluetoothBlocked;
            _x.cameraBlocked = cameraBlocked;
            _x.cellularBlockWifiTethering = cellularBlockWifiTethering;
            _x.compliantAppListType = compliantAppListType;
            _x.compliantAppsList = compliantAppsList;
            _x.compliantAppsListNextLink = compliantAppsListNextLink;
            _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
            _x.emailBlockAddingAccounts = emailBlockAddingAccounts;
            _x.locationServicesBlocked = locationServicesBlocked;
            _x.microsoftAccountBlocked = microsoftAccountBlocked;
            _x.nfcBlocked = nfcBlocked;
            _x.passwordBlockSimple = passwordBlockSimple;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.passwordRequired = passwordRequired;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
            _x.storageRequireEncryption = storageRequireEncryption;
            _x.webBrowserBlocked = webBrowserBlocked;
            _x.wifiBlockAutomaticConnectHotspots = wifiBlockAutomaticConnectHotspots;
            _x.wifiBlocked = wifiBlocked;
            _x.wifiBlockHotspotReporting = wifiBlockHotspotReporting;
            _x.windowsStoreBlocked = windowsStoreBlocked;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Value indicating whether this policy only applies to Windows Phone 8.1. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property applyOnlyToWindowsPhone81
     */
    @Property(name="applyOnlyToWindowsPhone81")
    @JsonIgnore
    public Optional<Boolean> getApplyOnlyToWindowsPhone81() {
        return Optional.ofNullable(applyOnlyToWindowsPhone81);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applyOnlyToWindowsPhone81} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating whether this policy only applies to Windows Phone 8.1. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param applyOnlyToWindowsPhone81
     *            new value of {@code applyOnlyToWindowsPhone81} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applyOnlyToWindowsPhone81} field changed
     */
    public WindowsPhone81GeneralConfiguration withApplyOnlyToWindowsPhone81(Boolean applyOnlyToWindowsPhone81) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applyOnlyToWindowsPhone81");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.applyOnlyToWindowsPhone81 = applyOnlyToWindowsPhone81;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block copy paste.”</i>
     * 
     * @return property appsBlockCopyPaste
     */
    @Property(name="appsBlockCopyPaste")
    @JsonIgnore
    public Optional<Boolean> getAppsBlockCopyPaste() {
        return Optional.ofNullable(appsBlockCopyPaste);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsBlockCopyPaste} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block copy paste.”</i>
     * 
     * @param appsBlockCopyPaste
     *            new value of {@code appsBlockCopyPaste} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsBlockCopyPaste} field changed
     */
    public WindowsPhone81GeneralConfiguration withAppsBlockCopyPaste(Boolean appsBlockCopyPaste) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsBlockCopyPaste");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.appsBlockCopyPaste = appsBlockCopyPaste;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block bluetooth.”</i>
     * 
     * @return property bluetoothBlocked
     */
    @Property(name="bluetoothBlocked")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlocked() {
        return Optional.ofNullable(bluetoothBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bluetoothBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block bluetooth.”</i>
     * 
     * @param bluetoothBlocked
     *            new value of {@code bluetoothBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withBluetoothBlocked(Boolean bluetoothBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.bluetoothBlocked = bluetoothBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block camera.”</i>
     * 
     * @return property cameraBlocked
     */
    @Property(name="cameraBlocked")
    @JsonIgnore
    public Optional<Boolean> getCameraBlocked() {
        return Optional.ofNullable(cameraBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameraBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block camera.”</i>
     * 
     * @param cameraBlocked
     *            new value of {@code cameraBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameraBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withCameraBlocked(Boolean cameraBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.cameraBlocked = cameraBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Wi-Fi tethering. Has no impact if Wi-Fi is
     * blocked.”</i>
     * 
     * @return property cellularBlockWifiTethering
     */
    @Property(name="cellularBlockWifiTethering")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockWifiTethering() {
        return Optional.ofNullable(cellularBlockWifiTethering);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockWifiTethering} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Wi-Fi tethering. Has no impact if Wi-Fi is
     * blocked.”</i>
     * 
     * @param cellularBlockWifiTethering
     *            new value of {@code cellularBlockWifiTethering} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockWifiTethering} field changed
     */
    public WindowsPhone81GeneralConfiguration withCellularBlockWifiTethering(Boolean cellularBlockWifiTethering) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockWifiTethering");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.cellularBlockWifiTethering = cellularBlockWifiTethering;
        return _x;
    }

    /**
     * <i>“List that is in the AppComplianceList.”</i>
     * 
     * @return property compliantAppListType
     */
    @Property(name="compliantAppListType")
    @JsonIgnore
    public Optional<AppListType> getCompliantAppListType() {
        return Optional.ofNullable(compliantAppListType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantAppListType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List that is in the AppComplianceList.”</i>
     * 
     * @param compliantAppListType
     *            new value of {@code compliantAppListType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantAppListType} field changed
     */
    public WindowsPhone81GeneralConfiguration withCompliantAppListType(AppListType compliantAppListType) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("compliantAppListType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.compliantAppListType = compliantAppListType;
        return _x;
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code compliantAppsList
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @param compliantAppsList
     *            new value of {@code compliantAppsList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantAppsList} field changed
     */
    public WindowsPhone81GeneralConfiguration withCompliantAppsList(List<AppListItem> compliantAppsList) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("compliantAppsList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.compliantAppsList = compliantAppsList;
        return _x;
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @return property diagnosticDataBlockSubmission
     */
    @Property(name="diagnosticDataBlockSubmission")
    @JsonIgnore
    public Optional<Boolean> getDiagnosticDataBlockSubmission() {
        return Optional.ofNullable(diagnosticDataBlockSubmission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticDataBlockSubmission} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @param diagnosticDataBlockSubmission
     *            new value of {@code diagnosticDataBlockSubmission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticDataBlockSubmission} field changed
     */
    public WindowsPhone81GeneralConfiguration withDiagnosticDataBlockSubmission(Boolean diagnosticDataBlockSubmission) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("diagnosticDataBlockSubmission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block custom email accounts.”</i>
     * 
     * @return property emailBlockAddingAccounts
     */
    @Property(name="emailBlockAddingAccounts")
    @JsonIgnore
    public Optional<Boolean> getEmailBlockAddingAccounts() {
        return Optional.ofNullable(emailBlockAddingAccounts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * emailBlockAddingAccounts} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block custom email accounts.”</i>
     * 
     * @param emailBlockAddingAccounts
     *            new value of {@code emailBlockAddingAccounts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailBlockAddingAccounts} field changed
     */
    public WindowsPhone81GeneralConfiguration withEmailBlockAddingAccounts(Boolean emailBlockAddingAccounts) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("emailBlockAddingAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.emailBlockAddingAccounts = emailBlockAddingAccounts;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block location services.”</i>
     * 
     * @return property locationServicesBlocked
     */
    @Property(name="locationServicesBlocked")
    @JsonIgnore
    public Optional<Boolean> getLocationServicesBlocked() {
        return Optional.ofNullable(locationServicesBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * locationServicesBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block location services.”</i>
     * 
     * @param locationServicesBlocked
     *            new value of {@code locationServicesBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code locationServicesBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withLocationServicesBlocked(Boolean locationServicesBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("locationServicesBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.locationServicesBlocked = locationServicesBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block using a Microsoft Account.”</i>
     * 
     * @return property microsoftAccountBlocked
     */
    @Property(name="microsoftAccountBlocked")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftAccountBlocked() {
        return Optional.ofNullable(microsoftAccountBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftAccountBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block using a Microsoft Account.”</i>
     * 
     * @param microsoftAccountBlocked
     *            new value of {@code microsoftAccountBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftAccountBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withMicrosoftAccountBlocked(Boolean microsoftAccountBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftAccountBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.microsoftAccountBlocked = microsoftAccountBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Near-Field Communication.”</i>
     * 
     * @return property nfcBlocked
     */
    @Property(name="nfcBlocked")
    @JsonIgnore
    public Optional<Boolean> getNfcBlocked() {
        return Optional.ofNullable(nfcBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code nfcBlocked} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to block Near-Field Communication.”</i>
     * 
     * @param nfcBlocked
     *            new value of {@code nfcBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nfcBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withNfcBlocked(Boolean nfcBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("nfcBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.nfcBlocked = nfcBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block syncing the calendar.”</i>
     * 
     * @return property passwordBlockSimple
     */
    @Property(name="passwordBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockSimple() {
        return Optional.ofNullable(passwordBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block syncing the calendar.”</i>
     * 
     * @param passwordBlockSimple
     *            new value of {@code passwordBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockSimple} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordBlockSimple(Boolean passwordBlockSimple) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordBlockSimple = passwordBlockSimple;
        return _x;
    }

    /**
     * <i>“Number of days before the password expires.”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days before the password expires.”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordExpirationDays(Integer passwordExpirationDays) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Number of character sets a password must contain.”</i>
     * 
     * @return property passwordMinimumCharacterSetCount
     */
    @Property(name="passwordMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumCharacterSetCount() {
        return Optional.ofNullable(passwordMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of character sets a password must contain.”</i>
     * 
     * @param passwordMinimumCharacterSetCount
     *            new value of {@code passwordMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumCharacterSetCount} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“Minimum length of passwords.”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum length of passwords.”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordMinimumLength(Integer passwordMinimumLength) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before screen timeout.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passwordMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before screen timeout.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“Number of previous passwords to block. Valid values 0 to 24”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of previous passwords to block. Valid values 0 to 24”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a password.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to require a password.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordRequired(Boolean passwordRequired) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Password type that is required.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Password type that is required.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordRequiredType(RequiredPasswordType passwordRequiredType) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“Number of sign in failures allowed before factory reset.”</i>
     * 
     * @return property passwordSignInFailureCountBeforeFactoryReset
     */
    @Property(name="passwordSignInFailureCountBeforeFactoryReset")
    @JsonIgnore
    public Optional<Integer> getPasswordSignInFailureCountBeforeFactoryReset() {
        return Optional.ofNullable(passwordSignInFailureCountBeforeFactoryReset);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordSignInFailureCountBeforeFactoryReset} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of sign in failures allowed before factory reset.”</i>
     * 
     * @param passwordSignInFailureCountBeforeFactoryReset
     *            new value of {@code passwordSignInFailureCountBeforeFactoryReset} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordSignInFailureCountBeforeFactoryReset} field changed
     */
    public WindowsPhone81GeneralConfiguration withPasswordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block screenshots.”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block screenshots.”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block removable storage.”</i>
     * 
     * @return property storageBlockRemovableStorage
     */
    @Property(name="storageBlockRemovableStorage")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockRemovableStorage() {
        return Optional.ofNullable(storageBlockRemovableStorage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockRemovableStorage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block removable storage.”</i>
     * 
     * @param storageBlockRemovableStorage
     *            new value of {@code storageBlockRemovableStorage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockRemovableStorage} field changed
     */
    public WindowsPhone81GeneralConfiguration withStorageBlockRemovableStorage(Boolean storageBlockRemovableStorage) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockRemovableStorage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require encryption.”</i>
     * 
     * @return property storageRequireEncryption
     */
    @Property(name="storageRequireEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireEncryption() {
        return Optional.ofNullable(storageRequireEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireEncryption} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require encryption.”</i>
     * 
     * @param storageRequireEncryption
     *            new value of {@code storageRequireEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireEncryption} field changed
     */
    public WindowsPhone81GeneralConfiguration withStorageRequireEncryption(Boolean storageRequireEncryption) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageRequireEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the web browser.”</i>
     * 
     * @return property webBrowserBlocked
     */
    @Property(name="webBrowserBlocked")
    @JsonIgnore
    public Optional<Boolean> getWebBrowserBlocked() {
        return Optional.ofNullable(webBrowserBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code webBrowserBlocked
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the web browser.”</i>
     * 
     * @param webBrowserBlocked
     *            new value of {@code webBrowserBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webBrowserBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withWebBrowserBlocked(Boolean webBrowserBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("webBrowserBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.webBrowserBlocked = webBrowserBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block automatically connecting to Wi-Fi hotspots.
     * Has no impact if Wi-Fi is blocked.”</i>
     * 
     * @return property wifiBlockAutomaticConnectHotspots
     */
    @Property(name="wifiBlockAutomaticConnectHotspots")
    @JsonIgnore
    public Optional<Boolean> getWifiBlockAutomaticConnectHotspots() {
        return Optional.ofNullable(wifiBlockAutomaticConnectHotspots);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wifiBlockAutomaticConnectHotspots} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block automatically connecting to Wi-Fi hotspots.
     * Has no impact if Wi-Fi is blocked.”</i>
     * 
     * @param wifiBlockAutomaticConnectHotspots
     *            new value of {@code wifiBlockAutomaticConnectHotspots} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiBlockAutomaticConnectHotspots} field changed
     */
    public WindowsPhone81GeneralConfiguration withWifiBlockAutomaticConnectHotspots(Boolean wifiBlockAutomaticConnectHotspots) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiBlockAutomaticConnectHotspots");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.wifiBlockAutomaticConnectHotspots = wifiBlockAutomaticConnectHotspots;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Wi-Fi.”</i>
     * 
     * @return property wifiBlocked
     */
    @Property(name="wifiBlocked")
    @JsonIgnore
    public Optional<Boolean> getWifiBlocked() {
        return Optional.ofNullable(wifiBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wifiBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block Wi-Fi.”</i>
     * 
     * @param wifiBlocked
     *            new value of {@code wifiBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withWifiBlocked(Boolean wifiBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.wifiBlocked = wifiBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Wi-Fi hotspot reporting. Has no impact if Wi-
     * Fi is blocked.”</i>
     * 
     * @return property wifiBlockHotspotReporting
     */
    @Property(name="wifiBlockHotspotReporting")
    @JsonIgnore
    public Optional<Boolean> getWifiBlockHotspotReporting() {
        return Optional.ofNullable(wifiBlockHotspotReporting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wifiBlockHotspotReporting} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Wi-Fi hotspot reporting. Has no impact if Wi-
     * Fi is blocked.”</i>
     * 
     * @param wifiBlockHotspotReporting
     *            new value of {@code wifiBlockHotspotReporting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiBlockHotspotReporting} field changed
     */
    public WindowsPhone81GeneralConfiguration withWifiBlockHotspotReporting(Boolean wifiBlockHotspotReporting) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiBlockHotspotReporting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.wifiBlockHotspotReporting = wifiBlockHotspotReporting;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the Windows Store.”</i>
     * 
     * @return property windowsStoreBlocked
     */
    @Property(name="windowsStoreBlocked")
    @JsonIgnore
    public Optional<Boolean> getWindowsStoreBlocked() {
        return Optional.ofNullable(windowsStoreBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsStoreBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the Windows Store.”</i>
     * 
     * @param windowsStoreBlocked
     *            new value of {@code windowsStoreBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsStoreBlocked} field changed
     */
    public WindowsPhone81GeneralConfiguration withWindowsStoreBlocked(Boolean windowsStoreBlocked) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsStoreBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81GeneralConfiguration");
        _x.windowsStoreBlocked = windowsStoreBlocked;
        return _x;
    }

    public WindowsPhone81GeneralConfiguration withUnmappedField(String name, Object value) {
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81GeneralConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81GeneralConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81GeneralConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsPhone81GeneralConfiguration _copy() {
        WindowsPhone81GeneralConfiguration _x = new WindowsPhone81GeneralConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.applyOnlyToWindowsPhone81 = applyOnlyToWindowsPhone81;
        _x.appsBlockCopyPaste = appsBlockCopyPaste;
        _x.bluetoothBlocked = bluetoothBlocked;
        _x.cameraBlocked = cameraBlocked;
        _x.cellularBlockWifiTethering = cellularBlockWifiTethering;
        _x.compliantAppListType = compliantAppListType;
        _x.compliantAppsList = compliantAppsList;
        _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
        _x.emailBlockAddingAccounts = emailBlockAddingAccounts;
        _x.locationServicesBlocked = locationServicesBlocked;
        _x.microsoftAccountBlocked = microsoftAccountBlocked;
        _x.nfcBlocked = nfcBlocked;
        _x.passwordBlockSimple = passwordBlockSimple;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordRequired = passwordRequired;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
        _x.storageRequireEncryption = storageRequireEncryption;
        _x.webBrowserBlocked = webBrowserBlocked;
        _x.wifiBlockAutomaticConnectHotspots = wifiBlockAutomaticConnectHotspots;
        _x.wifiBlocked = wifiBlocked;
        _x.wifiBlockHotspotReporting = wifiBlockHotspotReporting;
        _x.windowsStoreBlocked = windowsStoreBlocked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsPhone81GeneralConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("applyOnlyToWindowsPhone81=");
        b.append(this.applyOnlyToWindowsPhone81);
        b.append(", ");
        b.append("appsBlockCopyPaste=");
        b.append(this.appsBlockCopyPaste);
        b.append(", ");
        b.append("bluetoothBlocked=");
        b.append(this.bluetoothBlocked);
        b.append(", ");
        b.append("cameraBlocked=");
        b.append(this.cameraBlocked);
        b.append(", ");
        b.append("cellularBlockWifiTethering=");
        b.append(this.cellularBlockWifiTethering);
        b.append(", ");
        b.append("compliantAppListType=");
        b.append(this.compliantAppListType);
        b.append(", ");
        b.append("compliantAppsList=");
        b.append(this.compliantAppsList);
        b.append(", ");
        b.append("diagnosticDataBlockSubmission=");
        b.append(this.diagnosticDataBlockSubmission);
        b.append(", ");
        b.append("emailBlockAddingAccounts=");
        b.append(this.emailBlockAddingAccounts);
        b.append(", ");
        b.append("locationServicesBlocked=");
        b.append(this.locationServicesBlocked);
        b.append(", ");
        b.append("microsoftAccountBlocked=");
        b.append(this.microsoftAccountBlocked);
        b.append(", ");
        b.append("nfcBlocked=");
        b.append(this.nfcBlocked);
        b.append(", ");
        b.append("passwordBlockSimple=");
        b.append(this.passwordBlockSimple);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumCharacterSetCount=");
        b.append(this.passwordMinimumCharacterSetCount);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passwordMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordSignInFailureCountBeforeFactoryReset=");
        b.append(this.passwordSignInFailureCountBeforeFactoryReset);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("storageBlockRemovableStorage=");
        b.append(this.storageBlockRemovableStorage);
        b.append(", ");
        b.append("storageRequireEncryption=");
        b.append(this.storageRequireEncryption);
        b.append(", ");
        b.append("webBrowserBlocked=");
        b.append(this.webBrowserBlocked);
        b.append(", ");
        b.append("wifiBlockAutomaticConnectHotspots=");
        b.append(this.wifiBlockAutomaticConnectHotspots);
        b.append(", ");
        b.append("wifiBlocked=");
        b.append(this.wifiBlocked);
        b.append(", ");
        b.append("wifiBlockHotspotReporting=");
        b.append(this.wifiBlockHotspotReporting);
        b.append(", ");
        b.append("windowsStoreBlocked=");
        b.append(this.windowsStoreBlocked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
