package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.KeyStorageProviderOption;
import odata.msgraph.client.beta.enums.SubjectAlternativeNameType;
import odata.msgraph.client.beta.enums.SubjectNameFormat;


/**
 * <i>“Base Windows Phone 8.1+ certificate profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certificateValidityPeriodScale", 
    "certificateValidityPeriodValue", 
    "extendedKeyUsages", 
    "keyStorageProvider", 
    "renewalThresholdPercentage", 
    "subjectAlternativeNameType", 
    "subjectNameFormat"})
@JsonInclude(Include.NON_NULL)
public class WindowsPhone81CertificateProfileBase extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsPhone81CertificateProfileBase";
    }

    @JsonProperty("certificateValidityPeriodScale")
    protected CertificateValidityPeriodScale certificateValidityPeriodScale;

    @JsonProperty("certificateValidityPeriodValue")
    protected Integer certificateValidityPeriodValue;

    @JsonProperty("extendedKeyUsages")
    protected List<ExtendedKeyUsage> extendedKeyUsages;

    @JsonProperty("extendedKeyUsages@nextLink")
    protected String extendedKeyUsagesNextLink;

    @JsonProperty("keyStorageProvider")
    protected KeyStorageProviderOption keyStorageProvider;

    @JsonProperty("renewalThresholdPercentage")
    protected Integer renewalThresholdPercentage;

    @JsonProperty("subjectAlternativeNameType")
    protected SubjectAlternativeNameType subjectAlternativeNameType;

    @JsonProperty("subjectNameFormat")
    protected SubjectNameFormat subjectNameFormat;

    protected WindowsPhone81CertificateProfileBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Scale for the Certificate Validity Period.”</i>
     * 
     * @return property certificateValidityPeriodScale
     */
    @Property(name="certificateValidityPeriodScale")
    @JsonIgnore
    public Optional<CertificateValidityPeriodScale> getCertificateValidityPeriodScale() {
        return Optional.ofNullable(certificateValidityPeriodScale);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodScale} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Scale for the Certificate Validity Period.”</i>
     * 
     * @param certificateValidityPeriodScale
     *            new value of {@code certificateValidityPeriodScale} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodScale} field changed
     */
    public WindowsPhone81CertificateProfileBase withCertificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriodScale");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81CertificateProfileBase");
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        return _x;
    }

    /**
     * <i>“Value for the Certificate Validtiy Period.”</i>
     * 
     * @return property certificateValidityPeriodValue
     */
    @Property(name="certificateValidityPeriodValue")
    @JsonIgnore
    public Optional<Integer> getCertificateValidityPeriodValue() {
        return Optional.ofNullable(certificateValidityPeriodValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value for the Certificate Validtiy Period.”</i>
     * 
     * @param certificateValidityPeriodValue
     *            new value of {@code certificateValidityPeriodValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodValue} field changed
     */
    public WindowsPhone81CertificateProfileBase withCertificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriodValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81CertificateProfileBase");
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        return _x;
    }

    /**
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages() {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, this.extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code extendedKeyUsages
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @param extendedKeyUsages
     *            new value of {@code extendedKeyUsages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extendedKeyUsages} field changed
     */
    public WindowsPhone81CertificateProfileBase withExtendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("extendedKeyUsages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81CertificateProfileBase");
        _x.extendedKeyUsages = extendedKeyUsages;
        return _x;
    }

    /**
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages(HttpRequestOptions options) {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, this.extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Key Storage Provider (KSP).”</i>
     * 
     * @return property keyStorageProvider
     */
    @Property(name="keyStorageProvider")
    @JsonIgnore
    public Optional<KeyStorageProviderOption> getKeyStorageProvider() {
        return Optional.ofNullable(keyStorageProvider);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyStorageProvider} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Key Storage Provider (KSP).”</i>
     * 
     * @param keyStorageProvider
     *            new value of {@code keyStorageProvider} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyStorageProvider} field changed
     */
    public WindowsPhone81CertificateProfileBase withKeyStorageProvider(KeyStorageProviderOption keyStorageProvider) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("keyStorageProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81CertificateProfileBase");
        _x.keyStorageProvider = keyStorageProvider;
        return _x;
    }

    /**
     * <i>“Certificate renewal threshold percentage.”</i>
     * 
     * @return property renewalThresholdPercentage
     */
    @Property(name="renewalThresholdPercentage")
    @JsonIgnore
    public Optional<Integer> getRenewalThresholdPercentage() {
        return Optional.ofNullable(renewalThresholdPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * renewalThresholdPercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate renewal threshold percentage.”</i>
     * 
     * @param renewalThresholdPercentage
     *            new value of {@code renewalThresholdPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code renewalThresholdPercentage} field changed
     */
    public WindowsPhone81CertificateProfileBase withRenewalThresholdPercentage(Integer renewalThresholdPercentage) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("renewalThresholdPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81CertificateProfileBase");
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        return _x;
    }

    /**
     * <i>“Certificate Subject Alternative Name Type.”</i>
     * 
     * @return property subjectAlternativeNameType
     */
    @Property(name="subjectAlternativeNameType")
    @JsonIgnore
    public Optional<SubjectAlternativeNameType> getSubjectAlternativeNameType() {
        return Optional.ofNullable(subjectAlternativeNameType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectAlternativeNameType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate Subject Alternative Name Type.”</i>
     * 
     * @param subjectAlternativeNameType
     *            new value of {@code subjectAlternativeNameType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectAlternativeNameType} field changed
     */
    public WindowsPhone81CertificateProfileBase withSubjectAlternativeNameType(SubjectAlternativeNameType subjectAlternativeNameType) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("subjectAlternativeNameType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81CertificateProfileBase");
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        return _x;
    }

    /**
     * <i>“Certificate Subject Name Format.”</i>
     * 
     * @return property subjectNameFormat
     */
    @Property(name="subjectNameFormat")
    @JsonIgnore
    public Optional<SubjectNameFormat> getSubjectNameFormat() {
        return Optional.ofNullable(subjectNameFormat);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subjectNameFormat
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Certificate Subject Name Format.”</i>
     * 
     * @param subjectNameFormat
     *            new value of {@code subjectNameFormat} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectNameFormat} field changed
     */
    public WindowsPhone81CertificateProfileBase withSubjectNameFormat(SubjectNameFormat subjectNameFormat) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("subjectNameFormat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81CertificateProfileBase");
        _x.subjectNameFormat = subjectNameFormat;
        return _x;
    }

    public WindowsPhone81CertificateProfileBase withUnmappedField(String name, Object value) {
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81CertificateProfileBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81CertificateProfileBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81CertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsPhone81CertificateProfileBase _copy() {
        WindowsPhone81CertificateProfileBase _x = new WindowsPhone81CertificateProfileBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.extendedKeyUsages = extendedKeyUsages;
        _x.keyStorageProvider = keyStorageProvider;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.subjectNameFormat = subjectNameFormat;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsPhone81CertificateProfileBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append(", ");
        b.append("keyStorageProvider=");
        b.append(this.keyStorageProvider);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
